/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.kerneos.profile.file;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.ow2.kerneos.profile.KerneosProfile;
import org.ow2.kerneos.profile.config.generated.ObjectFactory;
import org.ow2.kerneos.profile.config.generated.Profile;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component
@Provides
public class ProfileFile
implements KerneosProfile,
Pojo {
    private InstanceManager __IM;
    private static final Log LOGGER = LogFactory.getLog(ProfileFile.class);
    private boolean __Fid;
    @Property(name="ID", mandatory=true)
    @ServiceProperty(name="ID")
    private String id;
    private boolean __Fbundle;
    @Property(name="bundle", mandatory=false)
    private String bundle;
    private boolean __Ffile;
    @Property(name="file", mandatory=true)
    private String file;
    private boolean __FbundleContext;
    private BundleContext bundleContext;
    private boolean __FjaxbContext;
    private JAXBContext jaxbContext;
    private boolean __Fprofile;
    private Profile profile;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MloadProfileConfig$java_io_InputStream;
    private boolean __MgetProfile;

    String __getid() {
        if (!this.__Fid) {
            return this.id;
        }
        return (String)this.__IM.onGet((Object)this, "id");
    }

    void __setid(String string) {
        if (!this.__Fid) {
            this.id = string;
            return;
        }
        this.__IM.onSet((Object)this, "id", (Object)string);
    }

    String __getbundle() {
        if (!this.__Fbundle) {
            return this.bundle;
        }
        return (String)this.__IM.onGet((Object)this, "bundle");
    }

    void __setbundle(String string) {
        if (!this.__Fbundle) {
            this.bundle = string;
            return;
        }
        this.__IM.onSet((Object)this, "bundle", (Object)string);
    }

    String __getfile() {
        if (!this.__Ffile) {
            return this.file;
        }
        return (String)this.__IM.onGet((Object)this, "file");
    }

    void __setfile(String string) {
        if (!this.__Ffile) {
            this.file = string;
            return;
        }
        this.__IM.onSet((Object)this, "file", (Object)string);
    }

    BundleContext __getbundleContext() {
        if (!this.__FbundleContext) {
            return this.bundleContext;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bundleContext");
    }

    void __setbundleContext(BundleContext bundleContext) {
        if (!this.__FbundleContext) {
            this.bundleContext = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bundleContext", (Object)bundleContext);
    }

    JAXBContext __getjaxbContext() {
        if (!this.__FjaxbContext) {
            return this.jaxbContext;
        }
        return (JAXBContext)this.__IM.onGet((Object)this, "jaxbContext");
    }

    void __setjaxbContext(JAXBContext jAXBContext) {
        if (!this.__FjaxbContext) {
            this.jaxbContext = jAXBContext;
            return;
        }
        this.__IM.onSet((Object)this, "jaxbContext", (Object)jAXBContext);
    }

    Profile __getprofile() {
        if (!this.__Fprofile) {
            return this.profile;
        }
        return (Profile)this.__IM.onGet((Object)this, "profile");
    }

    void __setprofile(Profile profile) {
        if (!this.__Fprofile) {
            this.profile = profile;
            return;
        }
        this.__IM.onSet((Object)this, "profile", (Object)profile);
    }

    ProfileFile(BundleContext bundleContext) throws Exception {
        this(null, bundleContext);
    }

    private ProfileFile(InstanceManager _manager, BundleContext bundleContext) throws Exception {
        this._setInstanceManager(_manager);
        this.__setbundleContext(bundleContext);
        this.__setjaxbContext(JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName(), (ClassLoader)ObjectFactory.class.getClassLoader()));
    }

    private void start() throws IOException {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() throws IOException {
        LOGGER.debug((Object)("Start ProfileFileInstall(" + this.__getid() + ")"), new Object[0]);
    }

    private void stop() throws IOException {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() throws IOException {
        LOGGER.debug((Object)("Stop ProfileFileInstall(" + this.__getid() + ")"), new Object[0]);
    }

    private Profile loadProfileConfig(InputStream inputStream) throws Exception {
        Profile profile;
        if (!this.__MloadProfileConfig$java_io_InputStream) {
            return this.__loadProfileConfig(inputStream);
        }
        try {
            this.__IM.onEntry((Object)this, "loadProfileConfig$java_io_InputStream", new Object[]{inputStream});
            profile = this.__loadProfileConfig(inputStream);
            this.__IM.onExit((Object)this, "loadProfileConfig$java_io_InputStream", (Object)profile);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadProfileConfig$java_io_InputStream", throwable);
            throw throwable;
        }
        return profile;
    }

    private Profile __loadProfileConfig(InputStream resource) throws Exception {
        try {
            Unmarshaller unmarshaller = this.__getjaxbContext().createUnmarshaller();
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal(resource);
            Profile profile = (Profile)element.getValue();
            return profile;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            resource.close();
        }
    }

    public synchronized Profile getProfile() {
        Profile profile;
        if (!this.__MgetProfile) {
            return this.__getProfile();
        }
        try {
            this.__IM.onEntry((Object)this, "getProfile", new Object[0]);
            profile = this.__getProfile();
            this.__IM.onExit((Object)this, "getProfile", (Object)profile);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProfile", throwable);
            throw throwable;
        }
        return profile;
    }

    private Profile __getProfile() {
        if (this.__getprofile() == null) {
            try {
                if (this.__getbundle() != null) {
                    for (Bundle bundle : this.__getbundleContext().getBundles()) {
                        if (!bundle.getSymbolicName().equals(this.__getbundle())) continue;
                        URL url = bundle.getResource(this.__getfile());
                        if (url != null) {
                            this.__setprofile(this.loadProfileConfig(url.openStream()));
                            return this.__getprofile();
                        }
                        LOGGER.error((Object)("File " + this.__getfile() + " not found in Bundle " + this.__getbundle()), new Object[0]);
                        return this.__getprofile();
                    }
                    LOGGER.error((Object)("Bundle " + this.__getbundle() + " not found"), new Object[0]);
                } else {
                    URL url = new URL(this.__getfile());
                    this.loadProfileConfig(url.openStream());
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Can't load the profile file", new Object[]{e});
            }
        }
        return this.__getprofile();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("id")) {
                this.__Fid = true;
            }
            if (set.contains("file")) {
                this.__Ffile = true;
            }
            if (set.contains("bundle")) {
                this.__Fbundle = true;
            }
            if (set.contains("jaxbContext")) {
                this.__FjaxbContext = true;
            }
            if (set.contains("bundleContext")) {
                this.__FbundleContext = true;
            }
            if (set.contains("profile")) {
                this.__Fprofile = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("loadProfileConfig$java_io_InputStream")) {
                this.__MloadProfileConfig$java_io_InputStream = true;
            }
            if (set.contains("getProfile")) {
                this.__MgetProfile = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

