/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.kerneos.profile.fileinstall;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.ow2.kerneos.profile.KerneosProfile;
import org.ow2.kerneos.profile.config.generated.ObjectFactory;
import org.ow2.kerneos.profile.config.generated.Profile;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component
@Provides
public class ProfileFileInstall
implements ArtifactInstaller,
KerneosProfile,
Pojo {
    private InstanceManager __IM;
    private static final Log LOGGER = LogFactory.getLog(ProfileFileInstall.class);
    private boolean __Fid;
    @Property(name="ID", mandatory=true)
    @ServiceProperty(name="ID")
    private String id;
    private boolean __Ffile;
    @Property(name="file", mandatory=true)
    private String file;
    private boolean __FeventAdmin;
    @Requires
    private EventAdmin eventAdmin;
    private boolean __FjaxbContext;
    private JAXBContext jaxbContext;
    private boolean __Fprofile;
    private Profile profile;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __Minstall$java_io_File;
    private boolean __Mupdate$java_io_File;
    private boolean __Muninstall$java_io_File;
    private boolean __McanHandle$java_io_File;
    private boolean __MloadProfileConfig$java_io_File;
    private boolean __MgetProfile;

    String __getid() {
        if (!this.__Fid) {
            return this.id;
        }
        return (String)this.__IM.onGet((Object)this, "id");
    }

    void __setid(String string) {
        if (!this.__Fid) {
            this.id = string;
            return;
        }
        this.__IM.onSet((Object)this, "id", (Object)string);
    }

    String __getfile() {
        if (!this.__Ffile) {
            return this.file;
        }
        return (String)this.__IM.onGet((Object)this, "file");
    }

    void __setfile(String string) {
        if (!this.__Ffile) {
            this.file = string;
            return;
        }
        this.__IM.onSet((Object)this, "file", (Object)string);
    }

    EventAdmin __geteventAdmin() {
        if (!this.__FeventAdmin) {
            return this.eventAdmin;
        }
        return (EventAdmin)this.__IM.onGet((Object)this, "eventAdmin");
    }

    void __seteventAdmin(EventAdmin eventAdmin) {
        if (!this.__FeventAdmin) {
            this.eventAdmin = eventAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "eventAdmin", (Object)eventAdmin);
    }

    JAXBContext __getjaxbContext() {
        if (!this.__FjaxbContext) {
            return this.jaxbContext;
        }
        return (JAXBContext)this.__IM.onGet((Object)this, "jaxbContext");
    }

    void __setjaxbContext(JAXBContext jAXBContext) {
        if (!this.__FjaxbContext) {
            this.jaxbContext = jAXBContext;
            return;
        }
        this.__IM.onSet((Object)this, "jaxbContext", (Object)jAXBContext);
    }

    Profile __getprofile() {
        if (!this.__Fprofile) {
            return this.profile;
        }
        return (Profile)this.__IM.onGet((Object)this, "profile");
    }

    void __setprofile(Profile profile) {
        if (!this.__Fprofile) {
            this.profile = profile;
            return;
        }
        this.__IM.onSet((Object)this, "profile", (Object)profile);
    }

    ProfileFileInstall() throws Exception {
        this(null);
    }

    private ProfileFileInstall(InstanceManager _manager) throws Exception {
        this._setInstanceManager(_manager);
        this.__setjaxbContext(JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName(), (ClassLoader)ObjectFactory.class.getClassLoader()));
    }

    private void start() throws IOException {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() throws IOException {
        LOGGER.debug((Object)("Start ProfileFileInstall(" + this.__getid() + ")"), new Object[0]);
    }

    private void stop() throws IOException {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() throws IOException {
        LOGGER.debug((Object)("Stop ProfileFileInstall(" + this.__getid() + ")"), new Object[0]);
    }

    public synchronized void install(File file) throws Exception {
        if (!this.__Minstall$java_io_File) {
            this.__M_install(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "install$java_io_File", new Object[]{file});
            this.__M_install(file);
            this.__IM.onExit((Object)this, "install$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "install$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_install(File file) throws Exception {
        try {
            this.__setprofile(this.loadProfileConfig(file));
            Hashtable<String, Profile> properties = new Hashtable<String, Profile>();
            ((Dictionary)properties).put("data", this.__getprofile());
            Event event = new Event("org/kerneos/application/" + this.__getid() + "/profile", properties);
            this.__geteventAdmin().sendEvent(event);
            LOGGER.info((Object)("New Kerneos Profile(" + this.__getid() + "): " + file.getPath()), new Object[0]);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex, new Object[]{"Invalid Kerneos Profile file(" + this.__getid() + "): " + file.getPath()});
        }
    }

    public synchronized void update(File file) throws Exception {
        if (!this.__Mupdate$java_io_File) {
            this.__M_update(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "update$java_io_File", new Object[]{file});
            this.__M_update(file);
            this.__IM.onExit((Object)this, "update$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "update$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_update(File file) throws Exception {
        try {
            this.__setprofile(this.loadProfileConfig(file));
            Hashtable<String, Profile> properties = new Hashtable<String, Profile>();
            ((Dictionary)properties).put("data", this.__getprofile());
            Event event = new Event("org/kerneos/application/" + this.__getid() + "/profile", properties);
            this.__geteventAdmin().sendEvent(event);
            LOGGER.info((Object)("Update Kerneos Profile(" + this.__getid() + "): " + file.getPath()), new Object[0]);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex, new Object[]{"Invalid Kerneos Profile file(" + this.__getid() + "): " + file.getPath()});
        }
    }

    public synchronized void uninstall(File file) throws Exception {
        if (!this.__Muninstall$java_io_File) {
            this.__M_uninstall(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "uninstall$java_io_File", new Object[]{file});
            this.__M_uninstall(file);
            this.__IM.onExit((Object)this, "uninstall$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "uninstall$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_uninstall(File file) throws Exception {
        try {
            this.__setprofile(null);
            LOGGER.info((Object)("Delete Kerneos Profile(" + this.__getid() + "): " + file.getPath()), new Object[0]);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex, new Object[]{"Invalid Kerneos Profile file(" + this.__getid() + "): " + file.getPath()});
        }
    }

    public boolean canHandle(File file) {
        boolean bl;
        if (!this.__McanHandle$java_io_File) {
            return this.__M_canHandle(file);
        }
        try {
            this.__IM.onEntry((Object)this, "canHandle$java_io_File", new Object[]{file});
            bl = this.__M_canHandle(file);
            this.__IM.onExit((Object)this, "canHandle$java_io_File", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "canHandle$java_io_File", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_canHandle(File file) {
        return file.getName().endsWith(this.__getfile());
    }

    private Profile loadProfileConfig(File file) throws Exception {
        Profile profile;
        if (!this.__MloadProfileConfig$java_io_File) {
            return this.__M_loadProfileConfig(file);
        }
        try {
            this.__IM.onEntry((Object)this, "loadProfileConfig$java_io_File", new Object[]{file});
            profile = this.__M_loadProfileConfig(file);
            this.__IM.onExit((Object)this, "loadProfileConfig$java_io_File", (Object)profile);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadProfileConfig$java_io_File", throwable);
            throw throwable;
        }
        return profile;
    }

    private Profile __M_loadProfileConfig(File file) throws Exception {
        FileInputStream resource = new FileInputStream(file);
        try {
            Unmarshaller unmarshaller = this.__getjaxbContext().createUnmarshaller();
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal((InputStream)resource);
            Profile profile = (Profile)element.getValue();
            return profile;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            ((InputStream)resource).close();
        }
    }

    public synchronized Profile getProfile() {
        Profile profile;
        if (!this.__MgetProfile) {
            return this.__M_getProfile();
        }
        try {
            this.__IM.onEntry((Object)this, "getProfile", new Object[0]);
            profile = this.__M_getProfile();
            this.__IM.onExit((Object)this, "getProfile", (Object)profile);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProfile", throwable);
            throw throwable;
        }
        return profile;
    }

    private Profile __M_getProfile() {
        return this.__getprofile();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("eventAdmin")) {
                this.__FeventAdmin = true;
            }
            if (set.contains("file")) {
                this.__Ffile = true;
            }
            if (set.contains("id")) {
                this.__Fid = true;
            }
            if (set.contains("jaxbContext")) {
                this.__FjaxbContext = true;
            }
            if (set.contains("profile")) {
                this.__Fprofile = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("install$java_io_File")) {
                this.__Minstall$java_io_File = true;
            }
            if (set.contains("update$java_io_File")) {
                this.__Mupdate$java_io_File = true;
            }
            if (set.contains("uninstall$java_io_File")) {
                this.__Muninstall$java_io_File = true;
            }
            if (set.contains("canHandle$java_io_File")) {
                this.__McanHandle$java_io_File = true;
            }
            if (set.contains("loadProfileConfig$java_io_File")) {
                this.__MloadProfileConfig$java_io_File = true;
            }
            if (set.contains("getProfile")) {
                this.__MgetProfile = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

