/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.api;

/** 
 * <P>This class predefines a set of levels. Indeed during the instrumentation,
 * developers must write calls to log an event with a specific level. One of 
 * the goals of Monolog is to be independent of the logging implementation.
 * To respect this goal, predefined variables or constants are needed. This 
 * class contains only static but not final variables to represent these 
 * predefined levels.</P>
 *
 * <P>To respect the flyweight pattern chosen in monolog specification, for each
 *  predefined level, a Level variable and an integer variable are declared.
 * Their values are not defined, in order to leave it to the implementation to
 * set them. </P>
 *
 * <P>This class defines five basic levels. But it is possible to a MonoLog user to 
 * define additional levels. Monolog allows this type of extension with some 
 * constraints or advices:
 * <UL>
 * <LI>If levels are not ordered, the additional levels must be defined by an 
 *    implementation of the Level interface.</LI>
 * <LI>If levels are ordered, all additional level must have an integer value 
 *    between the FATAL level and the DEBUG level.</LI>
 * <LI>If levels are ordered, it is possible to define a level with relative 
 *    integer value with an existent level 
 *    (MyLevel.FINE = BasicLevel.DEBUG + 2). This possibility imposes that 
 *    all MonoLog implementations define a set of sparse integer values for 
 *    the levels.</LI>
 * </UL></P>
 */
public class BasicLevel {

	/**
	 * In general, FATAL messages should describe events that are of 
	 * considerable importance and which will prevent continuation of the 
	 * program execution. They should be intelligible to end users and to 
	 * system administrators
	 */
	public static int FATAL ;
	/**
	 * In general, FATAL messages should describe events that are of 
	 * considerable importance and which will prevent continuation of the 
	 * program execution. They should be intelligible to end users and to 
	 * system administrators
	 */
	public static Level LEVEL_FATAL ;

	/**
	 *The ERROR level designates error events that might still allow the 
	 * application to continue running.
	 */
	public static int ERROR ;
	/**
	 *The ERROR level designates error events that might still allow the 
	 * application to continue running.
	 */
	public static Level LEVEL_ERROR ;

	/**
	 * In general, WARN messages should describe events that will be of 
	 * interest to end users or system managers, or which indicate potential
	 * problems.
	 */
	public static int WARN ;
	/**
	 * In general, WARN messages should describe events that will be of 
	 * interest to end users or system managers, or which indicate potential
	 * problems.
	 */
	public static Level LEVEL_WARN ;

	/**
	 * The INFO level designates informational messages that highlight the 
	 * progress of the application at a coarse-grained level.
	 */
	public static int INFO ;
	/**
	 * The INFO level designates informational messages that highlight the 
	 * progress of the application at a coarse-grained level.
	 */
	public static Level LEVEL_INFO ;

	/**
	 * DEBUG messages might include things like minor (recoverable) failures. 
	 * Logging calls for entering, returning, or throwing an exception can be 
	 * traced at this level.
	 */
	public static int DEBUG ;
	/**
	 * DEBUG messages might include things like minor (recoverable) failures. 
	 * Logging calls for entering, returning, or throwing an exception can be 
	 * traced at this level.
	 */
	public static Level LEVEL_DEBUG ;

	/**
	 * This special level indicates that the level is inherited from its
	 * ancestors.
	 */
	public static int INHERIT ;
	/**
	 * This special level indicates that the level is inherited from its
	 * ancestors.
	 */
	public static Level LEVEL_INHERIT ;

}
