/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.objectweb.util.monolog.api;

/**
 * Handler is an output. For example a
 * handler might be a console, a file, a socket, or a Logger.
 *
 * @author Sebastien Chassande-Barrioz
 */
public interface Handler {

	// Handler constant types //
	//------------------------//

	/**
	 * This constant is used to represent an handler which stores message into
	 * one file.
	 * @deprecated the type is a string now: "file"
	 */
	byte FILE_HANDLER_TYPE = 1;

	/**
	 * This constant is used to represent an handler which prints message on
	 * a console.
	 * @deprecated the type is a string now: "console"
	 */
	byte CONSOLE_HANDLER_TYPE = 2;

	/**
	 * This constant is used to represent an handler which stores message into
	 * several files.
	 */
	byte ROLLING_FILE_HANDLER_TYPE = 3;

	/**
	 * This constant is used to represent an handler which stores message into
	 * several files.
	 * @deprecated the type is a string now: "generic"
	 */
	byte GENERIC_HANDLER_TYPE = 4;

	/**
	 * This constant is used to represent an handler which is a Logger.
	 * @deprecated the type is a string now: "logger"
	 */
	byte LOGGER_HANDLER_TYPE = 5;

	/**
	 * This constant is used to represent a handler witch is a JMX notification emetter.
	 * @deprecated the type is a string now: "logger"
	 */
	byte JMX_HANDLER_TYPE = 6;

	// Handler attributes //
	//--------------------//

	String OUTPUT_ATTRIBUTE         = "output";
	String PATTERN_ATTRIBUTE        = "pattern";
	String LEVEL_ATTRIBUTE        = "level";

	String APPEND_MODE_ATTRIBUTE    = "appendMode";

	String FILE_NUMBER_ATTRIBUTE    = "fileNumber";
	String MAX_SIZE_ATTRIBUTE       = "maxSize";
	String BUFFER_ATTRIBUTE       = "bufferSize";


	/**
	 * It retrieves the name of the handler
	 */
	String getName();

	/**
	 * It assigns the name of the handler
	 */
	void setName(String name);

	/**
	 * It retrieves the Handler type
	 */
	String getType();

	/**
	 * It retrieves the attributes of the handler
	 */
	String[] getAttributeNames();

	/**
	 * It retrieves the value of an attribute value of the handler.
	 * @param name is an attribute name
	 */
	Object getAttribute(String name);

	/**
	 * It assigns an attributte to the handler.
	 * @param name is the attribute name
	 * @param value is the attribute value
	 * @return the old value is the attribute was already defined
	 */
	Object setAttribute(String name, Object value);
}
