/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.api;

/**
 * It permits to manage Handler instances.
 *
 * @author Sebastien Chassande-Barrioz
 */
public interface HandlerFactory {

	/**
	 * It retrieves a new instance of an handler which the type is specified
	 * by the parameter.
	 * @param 	handlertype is the type of the parameter. The possible value are
	 * 			defined in this interface by the XXX_HANDLER_TYPE constants.
	 * @return	a new instance of an handler
	 */
	Handler createHandler(String hn, String handlertype);

	/**
	 * It retrieves all handler managed by this factory.
	 * @return a set of Handler instance or an empty set.
	 */
	Handler[] getHandlers();

	/**
	 * It retrieves the handler which the name is specified by the parameter
	 * @param handlername is the name of the handler
	 * @return an handler instance or a null value.
	 */
	Handler getHandler(String handlername);

	/**
	 * It removes the handler which the name is specified by the parameter
	 * @param handlername is the name of the handler
	 * @return the removed handler instance or a null value if it does not
	 * exist.
	 */
	Handler removeHandler(String handlername);
}
