/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.objectweb.util.monolog.api;

/**
 * <P>The aims of this interface is to provide Logger instances, to allow 
 * instrumentation to be independent of the logging implementation and
 * to allow the use of the same logging implementation for all the 
 * components of a given application.</P>
 *
 * <P>This interface provides two methods to fetch Logger. If the Logger 
 * described by the parameters does not exist, then the LoggerFactory
 * must return a new instance of Logger.</P>
 * 
 * <P>The LoggerFactory interface also provides accessors to a resource 
 * bundle name associated to a LoggerFactory. This interface allows defining
 * a resource bundle name used by all Logger.</P>
 *
 * @author S.Chassande-Barrioz
 */
public interface LoggerFactory {
	
	/**
	 * This method permits to fetch a Logger. If the Logger 
	 * described by the parameters does not exist, then the LoggerFactory
	 * must return a new instance of Logger.
	 * The key parameter is a description of the expected Logger. In simple
	 * cases, the key is the initial topic of the Logger.
	 */
	Logger getLogger(String key);
	
	/**
	 * This method permits to fetch a Logger. If the Logger 
	 * described by the parameters does not exist, then the LoggerFactory
	 * must return a new instance of Logger.
	 * The key parameter is a description of the expected Logger. In simple
	 * cases, the key is the initial topic of the Logger.
	 * The resourceBundleName parameter allows specifying the name of a 
	 * resource bundle in order to internationalise the logging. 
	 */
	Logger getLogger(String key, String resourceBundleName);
	
	/**
	 * Accessors to a resource bundle name associated to a LoggerFactory.
	 */
	String getResourceBundleName();
	
	/**
	 * Accessors to a resource bundle name associated to a LoggerFactory.
	 */
	void setResourceBundleName(String resourceBundleName);

	/**
	 * It retrieves a list of all loggers.
	 */
	Logger[] getLoggers();
    
    /**
     * A Logger Factory can have a prefix helping for isolate applications. To
     * assume the isolation, a prefix can be used for topic name. 
     * @return the prefix of the topic name.
     */
    String getTopicPrefix();
}
