/**
 * Copyright (C) 2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.objectweb.util.monolog.api;

import java.util.Properties;

/**
 * A monolog factory is a factory for loggers, levels and handlers. It permits
 * also to configure specificaly a wrapper.
 *  
 * @author S.Chassande-Barrioz
 */
public interface MonologFactory
		extends LoggerFactory, LevelFactory, HandlerFactory {

	/**
	 * This constant can be used to specify the type of specific configuration
	 * which you need. The possible value are DEFAULT, PROPERTY and XML.
	 */
	String LOG_CONFIGURATION_TYPE = "log.config.type";

	/**
	 * This constant represents the default configuration type. It means that
	 * the wrapper must initialized the underlying sub system with the default
	 * configuration.
	 */
	String DEFAULT = "default";

	/**
	 * This constant represents the property configuration type. It means that
	 * the wrapper must used the LOG_CONFIGURATION_FILE constant to fetch the
	 * property file which describes the configuration.
	 */
	String PROPERTY = "property";

	/**
	 * This constant represents the xml configuration type. It means that
	 * the wrapper must used the LOG_CONFIGURATION_FILE constant to fetch the
	 * xml file which describes the configuration.
	 */
	String XML = "xml";

	/**
	 * This constant can be used to specify the specific configuration file.
	 */
	String LOG_CONFIGURATION_FILE = "log.config.file";

	/**
	 * This constant can be used to specify if the configuration file must be
	 * searched into the classpath
	 */
	String LOG_CONFIGURATION_FILE_USE_CLASSPATH
		= "log.config.file.useclasspath";

	/**
	 * This method permits to order to a monolog wrapper to configure the
	 * underlying log system.
	 * @param prop contains properties which describes the way to configure.
	 * In particular three properties could be used:
	 * <ul>
	 * <li>LOG_CONFIGURATION_TYPE</li>
	 * <li>LOG_CONFIGURATION_FILE</li>
	 * <li>LOG_CONFIGURATION_FILE_USE_CLASSPATH</li>
	 * <ul>
	 */
	void configure(Properties prop) throws Exception;

	/**
	 * register a listener for the events of this MonologFactory
	 */
	void addMonologFactoryListener(MonologFactoryListener mfl);
	
	/**
	 * forget a listener for the events of this MonologFactory
	 */
	void removeMonologFactoryListener (MonologFactoryListener mfl);

    /**
     * Add an extention
     * @param pattern Character corresponding to the info to add
     * @param logInfoProvider instance of info provider
     */
    void addLogInfo(Character pattern, LogInfo logInfoProvider) throws Exception;

    /**
     * Remove an extension
     * @param pattern log info pattern
     */
    void removeLogInfo (char pattern);

    /**
     * Gets the provider of the extension
     * @param pattern
     * @return LogInfo provider
     */
    LogInfo getLogInfo(Character pattern);
}
