/**
 * Copyright (C) 2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.objectweb.util.monolog.api;

/**
 * Defines a listener of event on a MonologFactory.
 * 
 * @author M.Idicheffou
 * @author S.chassande-Barrioz
 */
public interface MonologFactoryListener {
	
	/**
	 * It is called when a new handler has been created by the monolog factory
	 * @param handler is the created handler
	 */
    void handlerCreated (Handler handler);
	
	/**
	 * It i called when an handler has been removed by the monolog factory
	 * @param handler is the removed handler
	 */
	void handlerRemoved (Handler handler);
	
	/**
	 * It is called when a new level has been created by the monolog factory
	 * @param level is the created handler
	 */
	void levelCreated (Level level);
	
	/**
	 * It i called when a level has been removed by the monolog factory
	 * @param level is the removed handler
	 */
	void levelRemoved (Level level);
}
