/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.wrapper.common;

import java.util.Enumeration;

/**
 * This tools class is a basic implementation of the java.util.Enumeration.
 * This implementation is based on an object array.
 *
 * @author Sebastien Chassande-Barrioz
 */
public class EnumrationImpl implements Enumeration {

	protected Object[] objs = null;

	protected int pos;

	public EnumrationImpl(Object[] os) {
		objs = (os==null ? new Object[0] : os);
		pos = 0;
	}

	public boolean hasMoreElements() {
		return pos<objs.length;
	}

	public Object nextElement() {
		return objs[pos++];
	}
}
