/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.objectweb.util.monolog.wrapper.common;

import org.objectweb.util.monolog.Monolog;

/**
 *
 * this abstract class provides with the way to define a file real path with 
 * the value of environment variables value.<br/>
 * to do that, the path in the  the log properties file must include some variable
 * name those environment variable must be put in braket like <code>${MY_VARIABLE}</code>
 * <p><b>Example:</b> <code>${TOMCAT_HOME}/logs/${APPLICATION_NAME}_log_file.log</code></p>
 * @author franck Milleville fmillevi@yahoo.com 
 */
public abstract class RelatifEnvironmentPathGetter {
	static final String START = "${";
	static final String END = "}";
	/**
	 * This method replace environment variables name by its value (when any)
	 * @param path the file path including variable name 
	 * @return the file path with environment variable value
	 */
	public static String getRealPath(final String path) {
		if (0>path.indexOf(START)) {
			// no variable name in the path
			return path;
		}
		
		String realPath = "";
		int pathIndex = path.indexOf(START);
		for (int i=0; i<path.length(); i++) {
			if (pathIndex>=i) {
				realPath += path.substring(i,pathIndex);
				i = pathIndex;
				int endIndex = path.indexOf(END, pathIndex);
				if (0>endIndex) {
					Monolog.error("Error during getting the path '" 
							+ path + "'", new Exception("Bad file path conformance"));
					return path;
				}
				final String name = path.substring(pathIndex + START.length(), endIndex);
				final String value = System.getProperty(name);
				if (null==value) {
					Monolog.error("Error during getting the path '" 
							+ path + "'", new Exception("Unknown environment variable '" + name + "'"));
					return path;
				}
				realPath += value;
				i = endIndex;
				pathIndex = path.indexOf(START, i);
			} else {
				realPath += path.substring(i);
				i = path.length();
			}
		}
		return realPath;
	}
}
