/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.tests;

import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.Vector;
import junit.framework.TestCase;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.HandlerFactory;
import org.objectweb.util.monolog.api.LevelFactory;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.api.TopicalLogger;

public class MonologHelper
extends TestCase {
    public static final String[] SETTER_METHODS = new String[]{"setLoggerFactoryClassName"};
    public static LoggerFactory lf = null;
    public static HandlerFactory hf = null;
    public static LevelFactory lef = null;
    protected String fileName = null;
    static boolean debug = Boolean.valueOf(System.getProperty("monolog.test.debug"));

    public MonologHelper() {
        super("");
    }

    public MonologHelper(String s) {
        super(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setUp() throws Exception {
        if (lf != null) return;
        Class<MonologHelper> clazz = MonologHelper.class;
        synchronized (MonologHelper.class) {
            lf = Monolog.getMonologFactory((String)"monolog.properties");
            hf = (HandlerFactory)lf;
            lef = (LevelFactory)lf;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setLoggerFactoryClassName(String lfcn) {
        try {
            lf = (LoggerFactory)Class.forName(lfcn).newInstance();
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("The specified class is not a Logger factory: " + lfcn);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Logger factory class is not availlable: " + lfcn);
        }
        if (lf instanceof HandlerFactory) {
            hf = (HandlerFactory)lf;
        }
        if (lf instanceof LevelFactory) {
            lef = (LevelFactory)lf;
        }
    }

    public void setOutputFile(String filename) {
        this.fileName = filename;
    }

    public void assertInFileEquals(String message, String required) {
        String[] r = new String[]{required};
        this.assertInFileEquals(message, this.fileName, r);
    }

    public void assertInFileEquals(String message, String filename, String required) {
        String[] r = new String[]{required};
        this.assertInFileEquals(message, filename, r);
    }

    public void assertInFileEquals(String message, String[] required) {
        String[] text = this.getFirstLines(this.fileName, required.length);
        for (int i = 0; i < required.length; ++i) {
            this.debug("found : text[" + i + "]=" + text[i] + " text[i].length = " + text[i].length());
            this.debug("required : required[" + i + "]=" + required[i] + " required[i].length = " + required[i].length());
            MonologHelper.assertEquals((String)(message + " " + i), (String)required[i], (String)text[i]);
        }
    }

    public void assertInFileEquals(String message, String filename, String[] required) {
        String[] text = this.getFirstLines(filename, required.length);
        for (int i = 0; i < required.length; ++i) {
            this.debug("found : text[" + i + "]=" + text[i]);
            this.debug("required : required[" + i + "]=" + required[i]);
            MonologHelper.assertEquals((String)(message + " " + i), (String)required[i], (String)text[i]);
        }
    }

    public String[] getLastLines(int linenumber) {
        return this.getLastLines(this.fileName, linenumber);
    }

    public String[] getFirstLines(int linenumber) {
        return this.getFirstLines(this.fileName, linenumber);
    }

    public String[] getFirstLines(String filename, int linenumber) {
        if (filename == null || linenumber == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>(linenumber);
        try {
            FileReader fr = new FileReader(filename);
            LineNumberReader lnr = new LineNumberReader(fr);
            String str = lnr.readLine();
            for (int i = 0; i < linenumber && str != null; ++i) {
                v.addElement(str);
                str = lnr.readLine();
            }
            int size = v.size();
            String[] res = new String[size];
            for (int j = 0; j < size; ++j) {
                res[j] = (String)v.elementAt(j);
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] getLastLines(String filename, int linenumber) {
        if (filename == null || linenumber == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>(linenumber);
        try {
            FileReader fr = new FileReader(filename);
            LineNumberReader lnr = new LineNumberReader(fr);
            String str = lnr.readLine();
            int i = 0;
            while (str != null) {
                v.addElement(str);
                str = lnr.readLine();
                ++i;
            }
            int size = v.size();
            String[] res = new String[size];
            for (int j = 0; j < size; ++j) {
                res[j] = (String)v.elementAt(size - 1 - j);
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void quietRootLogger() {
        TopicalLogger l = (TopicalLogger)lf.getLogger("root");
        Handler[] hcs = l.getHandler();
        Handler hc = hf.createHandler("handlerOfroot", "file");
        hc.setAttribute("output", (Object)("target" + File.separator + "rootLogger.log"));
        hc.setAttribute("pattern", (Object)"%m%n");
        hc.setAttribute("activation", (Object)lf);
        try {
            l.addHandler(hc);
            for (int i = 0; i < hcs.length; ++i) {
                l.removeHandler(hcs[i]);
            }
        }
        catch (Exception e) {
            MonologHelper.fail((String)("error" + e.getMessage()));
        }
        l = null;
    }

    protected void debug(String m) {
        if (debug) {
            System.out.println(m);
        }
    }

    private int next(int i, int max) {
        return i + 1 == max ? 0 : i + 1;
    }
}

