/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.api.MonologFactory;

import java.util.Date;

import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;


/**
 * This example showing how to use monolog (initialisation and instrumentation).
 *
 * @author Sebastien Chassande-Barrioz
 */
public class JMX implements NotificationListener{
	public static void main(String[] args) {
		LoggerFactory lf;
		switch(args.length) {
		case 0:
			//Let monolog find the monolog.properties in the classpath or use
			// the default configuration
			lf = Monolog.initialize();
			break;
		case 1:
			// A monolog configuration file has been specified, then use it
			lf = Monolog.getMonologFactory(args[0]);
			break;
		default:
			System.out.println("Syntax error!\nUsage: java Simple [<monolog file name>]");
			return;
		}
		JMX s = new JMX(lf);
		s.activateNodification();
		s.foo();
		s.desactivateNodification();
	}

	private static final boolean DEBUG = false;

	protected Logger logger = null;

	public JMX(LoggerFactory lf) {
		logger = lf.getLogger("monolog.examples.jmx");
	}

	private void activateNodification() {
		Handler handler = Monolog.getMonologFactory().getHandler("jmxHandler");
		if (handler == null || !(handler instanceof NotificationEmitter)) {
			logger.log(BasicLevel.WARN, "No JMX handler in the configuration");
		} else {
			((NotificationEmitter) handler).addNotificationListener(this, null, null);
		}
	}
	private void desactivateNodification() {
		Handler handler = Monolog.getMonologFactory().getHandler("jmxHandler");
		if (handler == null || !(handler instanceof NotificationEmitter)) {
			logger.log(BasicLevel.WARN, "No JMX handler in the configuration");
		} else {
			try {
				logger.log(BasicLevel.DEBUG, "remove notification");
			    ((NotificationEmitter) handler).removeNotificationListener(this, null, null);
			} catch (ListenerNotFoundException lnfe){
				logger.log(BasicLevel.ERROR, 
				        "Error when desactivate the notification:", lnfe);
			}
		}
	}
	
	public void foo() {
		logger.log(BasicLevel.INFO, "foo : hello my favourite logger in info");
        logger.log(BasicLevel.WARN, "bar : warning !");
		logger.log(BasicLevel.ERROR, "This is a thrown exception", new Exception());
	}
	
	public void handleNotification(
	        Notification notification,
			java.lang.Object handback) {
		StringBuffer msg = new StringBuffer(250);
		msg.append("Notification ("
				+ new Date(notification.getTimeStamp()) + ")");
		msg.append("\n\t-Type: " + notification.getType());
		msg.append("\n\t-Src: " + notification.getSource());
		msg.append("\n\t-TimeStamp: " + notification.getTimeStamp());
		msg.append("\n\t-SequenceNumber: " + notification.getSequenceNumber());
		msg.append("\n\t-Message: " + notification.getMessage());
		msg.append("\n\t-UserData: " + notification.getUserData());
		msg.append("\n");
		System.out.println(msg);	
	}
}
