/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.api.MonologFactory;

public class JMX
implements NotificationListener {
    private static final boolean DEBUG = false;
    protected Logger logger = null;

    public static void main(String[] args) {
        MonologFactory lf;
        switch (args.length) {
            case 0: {
                lf = Monolog.initialize();
                break;
            }
            case 1: {
                lf = Monolog.getMonologFactory((String)args[0]);
                break;
            }
            default: {
                System.out.println("Syntax error!\nUsage: java Simple [<monolog file name>]");
                return;
            }
        }
        JMX s = new JMX((LoggerFactory)lf);
        s.activateNodification();
        s.foo();
        s.desactivateNodification();
    }

    public JMX(LoggerFactory lf) {
        this.logger = lf.getLogger("monolog.examples.jmx");
    }

    private void activateNodification() {
        Handler handler = Monolog.getMonologFactory().getHandler("jmxHandler");
        if (handler == null || !(handler instanceof NotificationEmitter)) {
            this.logger.log(BasicLevel.WARN, (Object)"No JMX handler in the configuration");
        } else {
            ((NotificationEmitter)handler).addNotificationListener(this, null, null);
        }
    }

    private void desactivateNodification() {
        Handler handler = Monolog.getMonologFactory().getHandler("jmxHandler");
        if (handler == null || !(handler instanceof NotificationEmitter)) {
            this.logger.log(BasicLevel.WARN, (Object)"No JMX handler in the configuration");
        } else {
            try {
                this.logger.log(BasicLevel.DEBUG, (Object)"remove notification");
                ((NotificationEmitter)handler).removeNotificationListener(this, null, null);
            }
            catch (ListenerNotFoundException lnfe) {
                this.logger.log(BasicLevel.ERROR, (Object)"Error when desactivate the notification:", (Throwable)lnfe);
            }
        }
    }

    public void foo() {
        this.logger.log(BasicLevel.INFO, (Object)"foo : hello my favourite logger in info");
        this.logger.log(BasicLevel.WARN, (Object)"bar : warning !");
        this.logger.log(BasicLevel.ERROR, (Object)"This is a thrown exception", (Throwable)new Exception());
    }

    public void handleNotification(Notification notification, Object handback) {
        StringBuffer msg = new StringBuffer(250);
        msg.append("Notification (" + new Date(notification.getTimeStamp()) + ")");
        msg.append("\n\t-Type: " + notification.getType());
        msg.append("\n\t-Src: " + notification.getSource());
        msg.append("\n\t-TimeStamp: " + notification.getTimeStamp());
        msg.append("\n\t-SequenceNumber: " + notification.getSequenceNumber());
        msg.append("\n\t-Message: " + notification.getMessage());
        msg.append("\n\t-UserData: " + notification.getUserData());
        msg.append("\n");
        System.out.println(msg);
    }
}

