/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;


/**
 * This example showing how to use monolog (initialisation and instrumentation).
 *
 * @author Sebastien Chassande-Barrioz
 */
public class Simple {
	public static void main(String[] args) {
		LoggerFactory lf;
		switch(args.length) {
		case 0:
			//Let monolog find the monolog.properties in the classpath or use
			// the default configuration
			lf = Monolog.initialize();
			break;
		case 1:
			// A monolog configuration file has been specified, then use it
			lf = Monolog.getMonologFactory(args[0]);
			break;
		default:
			System.out.println("Syntax error!\nUsage: java Simple [<monolog file name>]");
			return;
		}
		Simple s = new Simple(lf);
		s.foo();
		s.bar();
	}

	private static final boolean DEBUG = false;

	protected Logger logger = null;

	public Simple(LoggerFactory lf) {
		logger = lf.getLogger("monolog.examples.Simple");
	}

	public void foo() {
		if (logger.isLoggable(BasicLevel.DEBUG)) {
			logger.log(BasicLevel.DEBUG,
			    "my logger has been configured in order to log debug message");
		}
		logger.log(BasicLevel.INFO, "foo : hello my favourite logger in info");

		if (DEBUG && logger.isLoggable(BasicLevel.DEBUG)) {
			//This code is removed at compilation time because the DEBUG final
			// static field is equal to false.
			logger.log(BasicLevel.DEBUG, "This message should not appears");
		}
	}

	public void bar() {
        logger.log(BasicLevel.WARN, "bar : warning !");
		logger.log(BasicLevel.ERROR, "This is a throwed exception",
			new Throwable().fillInStackTrace());
	}
}
