/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.wrapper.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.objectweb.util.monolog.api.Handler;

/**
 * This class is a basic implementation the Handler interface. It is not linked
 * to any underlying log system. Therefore all attributes are stored into
 * internal struture.
 *
 * @author Sebastien Chassande-Barrioz
 */
public class BasicHandler implements Handler, Serializable {

	/**
	 * The name of the handler
	 */
	protected String name = null;

	/**
	 * The attributes of the handler are listed by this field.
	 * key = atribute name
	 * value = attribute value
	 */
	protected HashMap attributes = null;

	/**
	 * The type of the handler
	 */
	protected String type;

	public BasicHandler(String n, String t) {
		type = t;
		name = n;
		attributes = new HashMap();
	}

	public Map getAttributes() {
		return attributes;
	}

	public void setAttributes(Map properties) {
		attributes.clear();
		attributes.putAll(properties);
	}

	// IMPLEMENTATION OF THE Handler INTERFACE //
	//-----------------------------------------//

	public String getName() {
		return name;
	}

	public void setName(String n) {
		name = n;
	}

	public String getType() {
		return type;
	}

	public String[] getAttributeNames() {
		return (String[]) attributes.keySet().toArray(new String[0]);
	}

	public Object getAttribute(String key) {
		return attributes.get(key);
	}

	public Object setAttribute(String key, Object value) {
		return attributes.put(key, value);
	}
}
