/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.wrapper.log4j;

import java.util.HashMap;
import java.util.Map;

import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.wrapper.common.RelatifEnvironmentPathGetter;

/**
 *
 * @author Sebastien Chassande-Barrioz
 */
public class JMXHandler extends AppenderSkeleton implements NotificationEmitter, Handler {

	/**
	 * This fields contains the properties of the Handler
	 */
	protected HashMap prop = null;

	public JMXHandler() {
		super();
	}

	/**
	 * It Builds a new JMXHandler.
	 * @param name 	is the handler name.
	 */
	public JMXHandler(String name) {
		super();
		setName(name);
		prop = new HashMap();
	}
	CustomNotificationBroadcasterSupport emitter = new  CustomNotificationBroadcasterSupport();
	
	public void addNotificationListener(NotificationListener listener,
            NotificationFilter filter,
            Object handback)
            throws IllegalArgumentException {
		emitter.addNotificationListener( listener, filter, handback );
	}
	
	public void removeNotificationListener( NotificationListener listener )
    throws ListenerNotFoundException {
		emitter.removeNotificationListener( listener );
	}
	
	public void removeNotificationListener( NotificationListener listener, 
			NotificationFilter filter, Object handback) 
			throws ListenerNotFoundException {
		emitter.removeNotificationListener( listener, filter, handback );
	}
	
	public MBeanNotificationInfo[] getNotificationInfo(){
		return emitter.getNotificationInfo();
	}
	
	public Map getAttributes() {
		return prop;
	}

	public void setAttributes(Map attributes) {
		prop.clear();
		prop.putAll(attributes);
		Object mf = prop.get("activation");
		if (mf != null) {
		    prop.remove("activation");
		    setAttribute("activation", mf);
		}
	}

	// IMPLEMENTATION OF THE Handler INTERFACE //
	//---------------------------------------------//
	public String getType() {
		return "jmx";
	}

	public String[] getAttributeNames() {
		return (String[]) prop.keySet().toArray(new String[0]);
	}

	public Object getAttribute(String key) {
		return prop.get(key);
	}

	public Object setAttribute(String key, Object value) {
		if (prop == null)
			prop = new HashMap();
		if (!key.equalsIgnoreCase("activation")) {
			return prop.put(key, value);
		} else if (prop.containsKey(key)) {
		    return null; //already activated
		}
		MonologFactory mf = (MonologFactory) value;
		String pattern = (String) prop.get(Handler.PATTERN_ATTRIBUTE);
		if (pattern != null) {
		    setLayout(new PatternLayout(PatternConverter.monolog2log4j(pattern)));
		}
		
		String level = (String) prop.get(Handler.LEVEL_ATTRIBUTE);
		if (level != null && level.length() > 0) {
			int levelVal = org.objectweb.util.monolog.wrapper.common.LevelImpl.evaluate(level, mf);
			setThreshold(org.apache.log4j.Level.toLevel(levelVal));
		}
		
		String output = (String) prop.get(Handler.OUTPUT_ATTRIBUTE);
		output = RelatifEnvironmentPathGetter.getRealPath(output);
		
		super.activateOptions();
		return null;
	}

	private long notificationSequence = 0;
	
	/* (non-Javadoc)
	 * @see org.apache.log4j.AppenderSkeleton#append(org.apache.log4j.spi.LoggingEvent)
	 */
	public void doAppend(LoggingEvent event) {
		Notification notification = new Notification ("Monolog.JMXHandler.Log",
				"JMXHandler:Type=Log4j",++notificationSequence,
				System.currentTimeMillis(), event.getMessage().toString());
		notification.setUserData(event);
		emitter.sendNotification(notification);
	}
	
	class CustomNotificationBroadcasterSupport extends NotificationBroadcasterSupport {
		
		public void sendNotification (Notification notification) {
			super.sendNotification (notification);	
		}
	}

	/* (non-Javadoc)
	 * @see org.apache.log4j.AppenderSkeleton#append(org.apache.log4j.spi.LoggingEvent)
	 */
	protected void append(LoggingEvent event) {
		this.append(event);	
	}

	/* (non-Javadoc)
	 * @see org.apache.log4j.Appender#close()
	 */
	public void close() {
		if (this != null) {
			this.close();
		}
		
	}

	/* (non-Javadoc)
	 * @see org.apache.log4j.Appender#requiresLayout()
	 */
	public boolean requiresLayout() {
		// TODO Auto-generated method stub
		return false;
	}

}

