/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.objectweb.util.monolog.wrapper.p6spy;

import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

import com.p6spy.engine.logging.appender.FormattedLogger;
import com.p6spy.engine.logging.appender.P6Logger;

/**
 * This class is a wrapper between the P6spy loggiing module and monolog. The
 * aim is to log the SQL queries into a monolog loggger. 
 * @author S.Chassande-Barrioz
 */
public class P6SpyLogger
        extends FormattedLogger
        implements P6Logger {

    public static int level;
    public static Logger logger;

    public P6SpyLogger() {
        level = BasicLevel.DEBUG;
    }

    // IMPLEMENTATION OF THE FormattedLogger INTERFACE //
    //-------------------------------------------------//

    public void logText(String s) {
        if (logger == null) {
            System.out.println(s);
        } else if (logger.isLoggable(level)) {
            logger.log(level, s);
        }
    }


    // IMPLEMENTATION OF THE P6Logger INTERFACE //
    //------------------------------------------//

    public void logException(Exception e) {
        if (logger == null) {
            e.printStackTrace(System.out);
        } else if (logger.isLoggable(level)) {
            logger.log(level, e.getMessage(), e);
        }
    }
}
