/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ow2.opensuit.cel;

import org.ow2.opensuit.cel.impl.ExpressionFactoryImpl;

/**
 * Represent the factory that allow to
 * recover the implementation.
 * @author Adrien Ruffie / Pierre Smeyers
 * @author http://opensuit.ow2.org/
 * @version 1.0
 */
public abstract class ExpressionFactory
{
	public static ExpressionFactory newInstance(ITypeConverter converter)
	{
		return new ExpressionFactoryImpl(converter);
	}
	private ITypeConverter converter;
	
	protected ExpressionFactory(ITypeConverter converter)
	{
		this.converter = converter;
	}
	public ITypeConverter getConverter()
	{
		return converter;
	}	
	
	/**
	 * Allow to compile the provided expression into the associated 
	 * compilation context
	 * @param iContext The context with which the compilation is performed
	 * @param expr The <String> value of the expression
	 * @return IReaderCompilationResult
	 */
	public abstract ICompilationResult compileExpression(ICompilationContext iContext, String expr);
}
