/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ow2.opensuit.cel;

/**
 * Interface declaring all methods which
 * must be implemented, by a class
 * which implements <ICompilationMessage>.
 * Represent the compilation message behavior.
 * @author Adrien Ruffie / Pierre Smeyers
 * @author http://opensuit.ow2.org/
 * @version 1.0
 */
public interface ICompilationMessage
{
	public final static int INFO_LEVEL = 0;
	public final static int WARNING_LEVEL = 1;
	public final static int ERROR_LEVEL = 2;

	/**
	 * Get the position into the expression,
	 * associated with the compilation message .
	 * @return Integer of the message position
	 * into the expression.
	 */
	int getPosition();
	
	/**
     * Get the level of the compilation message .
     * @return Integer of the message level.
     */
	int getLevel();
	
	/**
	 * Get the <String> value of the compilation
	 * message.
	 * @return The <String> value of the
	 * compilation message content.
	 */
	String getMessage();
}
