/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ow2.opensuit.cel;

import java.util.List;

/**
 * Interface declaring all methods which
 * must be implemented, by a class
 * which implements <ICompilationResult>.
 * Represent the compilation result behavior 
 * @author Adrien Ruffie / Pierre Smeyers
 * @author http://opensuit.ow2.org/
 * @version 1.0
 */
public interface ICompilationResult
{
    /**
     * Get the <IExpression> linked this
     * compilation result.
     * @return Return an implementation
     * of IExpression associated with this
     * compilation result.
     */
	IExpression getExpression();
	
	/**
	 * Allow to determine if errors
	 * Occurred during the compilation
	 * @return Return true if occurred 
	 * errors are present into this 
	 * compilation result
	 */
	boolean hasErrors();
	
	/**
	 * Allow to recover all <ICompilationMessage>
	 * linked to the current <ICompilationResult>
	 * @return A <List> of <ICompilationMessage>
	 * occurred
	 */
	List<ICompilationMessage> getMessages();
}
