/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ow2.opensuit.cel;

import org.ow2.opensuit.cel.ICompilationContext.IFunctionContext;

/**
 * Interface declaring all methods which
 * must be implemented, by a class
 * which implements <IEvaluationContext>.
 * Represent the evaluation context behavior .
 * @author Adrien Ruffie / Pierre Smeyers
 * @author http://opensuit.ow2.org/
 * @version 1.0
 */
public interface IEvaluationContext
{
    /**
     * Return the variable linked to the iName
     * parameter which can be located into
     * this evaluation context
     * @param iName The variable name
     * searched into a <IEvaluationContext>
     * @return Return the searched <Object>
     * from this <IEvaluationContext> 
     * @throws Exception
     */
	Object getVariable(String iName) throws Exception;
	
	 /**
     * Return the <Object> owner of the specified
     * function, located into this evaluation context
     * @param function The <IFunctionContext>
     * of the demanded method
     * @return Return the searched <Object>
     * with the bound function from this
     * <IEvaluationContext> 
     * @throws Exception
     */
	Object getFunctionObject(IFunctionContext function);
}
