/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ow2.opensuit.cel;

import java.lang.reflect.Type;

/**
 * This interface declare the available methods
 * for an expression
 * @author Adrien Ruffie / Pierre Smeyers
 * @author http://opensuit.ow2.org/
 * @version 1.0
 */
public interface IExpression
{
	/**
	 * Evaluates the expression.
	 */
	Object invoke(IEvaluationContext iContext) throws Exception;
	
	/**
	 * Returns the expression type
	 */
	Class<?> getType();
	
	/**
	 * Returns the expression generic type
	 */
	Type getGenericType();
	
	/**
	 * Returns <code>true</code> if the expression cannot be set
	 * @return boolean
	 */
	boolean isReadOnly();
	
	/**
	 * Returns <code>true</code> if the expression has a static value (i.e. that does
	 * not depend on any evaluation context).
	 * In such a case, the <code>invoke(...)</code> method may be called with a null
	 * evaluation context.
	 * @return boolean
	 */
	boolean isStaticValue();
	
	/**
	 * Returns the string value pattern (regular expression).
	 * @return String
	 */
	String getValuePattern();
	
	/**
	 * Assigns a value to this expression (if no read only)
	 */
	void set(IEvaluationContext iContext, Object iValue) throws Exception;
	
	/**
	 * Returns the expression string
	 * @return String
	 */
	String getExpressionString();
}
