/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ow2.opensuit.cel;

/**
 * Interface for types conversion
 * @author Adrien Ruffie / Pierre Smeyers
 * @author http://opensuit.ow2.org/
 * @version 1.0
 */
public interface ITypeConverter
{
    
	/**
	 * Determines whether the source type can be converted to the target type.
	 * @param sourceType The source type which should be converted
	 * @param targetType The targeted type by the conversion
	 * @return boolean
	 */
	public boolean isConvertible(Class<?> sourceType, Class<?> targetType);
	
	/**
	 * Convert the given input value to the specified target type.
	 * @param value The given input value which
     * should be converted
	 * @param <T> type The targeted type of the conversion
	 * @return <T> the targeted type of the conversion
	 * @throws Exception
	 */
	public <T> T convert(Object value, Class<T> type) throws Exception;
}
