/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ow2.opensuit.cel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.ow2.opensuit.cel.ICompilationMessage;
import org.ow2.opensuit.cel.IExpression;
import org.ow2.opensuit.cel.impl.tree.IExprNode;


/**
 * Interface for types conversion
 * @author Adrien Ruffie / Pierre Smeyers
 * @author http://opensuit.ow2.org/
 * @version 1.0
 */
public class CompilationResult implements ICompilationResultWriter
{
	private IExpression expression;
	private List<ICompilationMessage> messages = Collections.emptyList();
	
	public IExpression getExpression()
	{
		return expression;
	}
	public void setExpression(IExpression expression)
	{
		this.expression = expression;
	}
	public List<ICompilationMessage> getMessages()
	{
		return messages;
	}
	public boolean hasErrors()
	{
		for(ICompilationMessage m : messages)
		{
			if(m.getLevel() == ICompilationMessage.ERROR_LEVEL){
				return true;
			}
		}
		return false;
	}
	public void addMessage(IExprNode node, int level, String message)
	{
		addMessage(node.getPosition(), level, message);
	}
	public void addMessage(int position, int level, String message)
	{
		if(messages.size() == 0){
			messages = new ArrayList<ICompilationMessage>(1);
		}
		
		messages.add(new MessageImpl(position, level, message));
	}
	
	private static class MessageImpl implements ICompilationMessage
	{
		private int position;
		private int level;
		private String message;
		
		public MessageImpl(int position, int level, String message)
		{
			this.position = position;
			this.level = level;
			this.message = message;
		}
		public int getLevel()
		{
			return level;
		}
		public String getMessage()
		{
			return message;
		}
		public int getPosition()
		{
			return position;
		}
	}
}
