/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ow2.opensuit.cel.impl;

import org.ow2.opensuit.cel.ExpressionFactory;
import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.ICompilationMessage;
import org.ow2.opensuit.cel.ICompilationResult;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.tree.IExprNode;
import org.ow2.opensuit.cel.impl.tree.impl.Parser;
import org.ow2.opensuit.cel.impl.tree.impl.Parser.ParseException;
import org.ow2.opensuit.cel.impl.tree.impl.Scanner.ScanException;

/**
 * @author Adrien Ruffie / Pierre Smeyers
 * @author http://opensuit.ow2.org/
 * @version 1.0
 */
public class ExpressionFactoryImpl extends ExpressionFactory
{
	public ExpressionFactoryImpl(ITypeConverter converter)
	{
		super(converter);
	}

	@Override
	public ICompilationResult compileExpression(ICompilationContext iContext, String expression)
	{
		CompilationResult result = new CompilationResult();
		// --- parse
		Parser parser = new Parser(expression);
		IExprNode rootExprNode;
		try
		{
			rootExprNode = parser.parse();

			result.setExpression(rootExprNode);
			// --- compile
			rootExprNode.compile(getConverter(), iContext, result);
		}
		catch (ScanException e)
		{
			result.addMessage(e.getPosition(), ICompilationMessage.ERROR_LEVEL, e.getMessage());
		}
		catch (ParseException e)
		{
			result.addMessage(e.getPosition(), ICompilationMessage.ERROR_LEVEL, e.getMessage());
		}

		return result;
	}
}
