package org.ow2.opensuit.cel.impl.misc;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public final class ParameterizedTypeNoVariable implements ParameterizedType {
    
    ParameterizedType pt;
    Type[] typeArgs;
	
	public static ParameterizedType getNoVariable(ParameterizedType pt, ParameterizedType parentType)
	{
		ParameterizedTypeNoVariable wrap = null;
		Type[] typeArgs = pt.getActualTypeArguments();
		for (int i=0; i<typeArgs.length; i++)
		{
			if (typeArgs[i] instanceof TypeVariable<?>)
			{
				if(wrap == null){
					wrap = new ParameterizedTypeNoVariable(pt);
				}
				
				TypeVariable<?> tv = (TypeVariable<?>) typeArgs[i];
				if (parentType.getRawType().equals(tv.getGenericDeclaration()))
				{
					// --- look for variable type in parent
					TypeVariable<?>[] parentDeclaredTypes = tv.getGenericDeclaration().getTypeParameters();
					int idx = 0;
					
					while (idx < parentDeclaredTypes.length
							&& !parentDeclaredTypes[idx].equals(tv)){
						idx++;
					}
					
					if (idx < parentDeclaredTypes.length)
					{
						// --- declared type index found
						if(parentType.getActualTypeArguments() != null && idx < parentType.getActualTypeArguments().length){
							wrap.typeArgs[i] = parentType.getActualTypeArguments()[idx];
						}
					}
					else
					{
						// --- oops! type not found (should not happen)
						return pt;
					}
				}
				// else parent type is not where the type variable was declared
			}
		}
		return wrap == null ? pt : wrap;
	}

	private ParameterizedTypeNoVariable(ParameterizedType pt) {
		this.pt = pt;
		typeArgs = pt.getActualTypeArguments();
	}


	public Type getRawType() {
		return pt.getRawType();
	}

	public Type getOwnerType() {
		return pt.getOwnerType();
	}

	public Type[] getActualTypeArguments() {
		return typeArgs;
	}

}
