/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ow2.opensuit.cel.impl.misc;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;


public class RegExpBuilder
{
	public static void appendTypeExpr(StringBuilder builder, Type type)
	{
		if(type == Boolean.class || type == Boolean.TYPE)
		{
			// --- string
			builder.append("(true|false)");
		}
		else if (type == Short.class || type == Short.TYPE || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == BigInteger.class)
		{
			// --- integer
			builder.append("\\d+");
		}
		else if (type == Float.class || type == Float.TYPE || type == Double.class || type == Double.TYPE || type == BigDecimal.class)
		{
			// --- decimal
			builder.append("\\d*\\.?\\d+");
		}
		else if(type == Byte.class || type == Byte.TYPE)
		{
			// --- ???
			builder.append("\\d+");
		}
		else if(type == Character.class || type == Character.TYPE)
		{
			// --- char
			builder.append(".");
		}
		else if(type instanceof Class<?> && ((Class<?>)type).isEnum())
		{
			Object[] values = ((Class<?>)type).getEnumConstants();
			builder.append("(");
			for(int i=0; i<values.length; i++)
			{
				if(i>0){
					builder.append("|");
				}
				
				builder.append(values[i]);
			}
			builder.append(")");
		}
		else
		{
			// --- String or other: allow any string
			builder.append(".*");
		}
	}
	public static void appendString(StringBuilder builder, String value)
	{
		/*
		builder.append("\\Q");// escape all
		builder.append(value);
		builder.append("\\E");// unescape all
		 */
		for(int i=0; i<value.length(); i++)
		{
			char c = value.charAt(i);
			switch (c)
			{
				// --- chars that need to be escaped
				case '.':
				case '(':
				case ')':
				case '{':
				case '}':
				case '\\':
				case '*':
				case '?':
				case '+':
				case '-':
				case '^':
				case '$':
					builder.append('\\');
					builder.append(c);
					break;
				// --- char that need to be translated
				case '\n':
					builder.append("\\n");
					break;
				case '\t':
					builder.append("\\t");
					break;
				default:
					builder.append(c);
					break;
			}
		}
	}
}
