/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.opensuit.cel.impl.tree;

import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IExpression;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;


/**
 * Basic node interface. The purpose of this
 * node is to represent a expression
 * @author Adrien Ruffie / Pierre Smeyers
 * @author http://opensuit.ow2.org/
 * @version 1.0
 */
public interface IExprNode extends IExpression
{
//	public String getExpression();
	
	public int getPosition();

	/**
	 * Allow to compile the given expression with the associated
	 * <ITypeConverter> and <ICompilationContext>. All
	 * messages will be stored into the <CompilationResult> at
	 * the end of the performed compilation.
	 * @param converter Interface for conversion types
	 * @param context Interface for compilation context
	 * @param results Represent where the messages compilation
	 * will be stored
	 * @return <boolean>
	 */
	public boolean compile(ITypeConverter converter, ICompilationContext context, ICompilationResultWriter results);
	
	/*
	public Object invoke(IEvaluationContext context) throws ExpressionEvaluationException;
	public void set(IEvaluationContext context, Object value) throws ExpressionEvaluationException;
	*/
}
