package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;

import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;


public final class AstBoolean extends AstLiteral
{
	private final boolean value;

	public AstBoolean(int position, boolean value)
	{
		super(position);
		this.value = value;
	}

	public Object invoke(IEvaluationContext context) throws ExpressionEvaluationException
	{
		return value;
	}

	public Class<?> getType()
	{
		return Boolean.TYPE;
	}

	public Type getGenericType()
	{
		return Boolean.TYPE;
	}

	@Override
	protected void appendExpressionString(StringBuilder builder)
	{
		builder.append(value);
	}

	@Override
	protected void appendValuePattern(StringBuilder builder)
	{
		builder.append(String.valueOf(value));
	}
}
