package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.ICompilationMessage;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;



public class AstBracket extends AstProperty
{
	private ITypeConverter converter;
	protected final AstNode property;
	private Class<?> returnClass;
	private Type returnType;

	public AstBracket(int position, AstNode base, AstNode property, boolean lvalue) {
		super(position, base, lvalue);
		this.property = property;
	}
	public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages)
	{
		this.converter = converter;
		
		// --- 1: compile children
		boolean compiled = prefix.compile(converter, ctx, messages);
		compiled = property.compile(converter, ctx, messages) && compiled;
		
		if(!compiled){
			return false;
		}
		
		// --- 2: compile this
		Type objType = prefix.getGenericType();
		Class<?> objClass = prefix.getType();
		Class<?> propertyClass = property.getType();
		if(objClass.isArray())
		{
			// --- item must be of type int
			if(!converter.isConvertible(propertyClass, Integer.class))
			{
				messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "Bracket argument for an array must be either int or Integer.");
				return false;
			}
			returnClass = objClass.getComponentType();
			returnType = returnClass;
			
			if(objType instanceof GenericArrayType){
				returnType = ((GenericArrayType)objType).getGenericComponentType();
			}
			
			return true;
		}
		else if(List.class.isAssignableFrom(objClass))
		{
			// --- item must be of type int
			if(!converter.isConvertible(propertyClass, Integer.class))
			{
				messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "Bracket argument for a List must be either int or Integer.");
				return false;
			}
			
			returnType = Object.class;
			returnClass = Object.class;
			
			if(objType instanceof ParameterizedType)
			{
				returnType = ((ParameterizedType)objType).getActualTypeArguments()[0];
				
				if(returnType instanceof Class<?>){
					returnClass = (Class<?>)returnType;
				}else if(returnType instanceof ParameterizedType){
					returnClass = (Class<?>)((ParameterizedType)returnType).getRawType();
				}
			}
			return true;
		}
		else if(Map.class.isAssignableFrom(objClass))
		{
			// --- item can be of any type
			returnType = Object.class;
			returnClass = Object.class;
			if(objType instanceof ParameterizedType)
			{
				// --- get return type
				returnType = ((ParameterizedType)objType).getActualTypeArguments()[1];
				
				// --- check item type
				Class<?> declaredItemClass = null;
				Type declaredItemType = ((ParameterizedType)objType).getActualTypeArguments()[0];
				if(declaredItemType instanceof Class<?>){
					declaredItemClass = (Class<?>)declaredItemType;
				}else if(declaredItemType instanceof ParameterizedType){
					declaredItemClass = (Class<?>)((ParameterizedType)declaredItemType).getRawType();
				}
				
				if(declaredItemClass != null && !converter.isConvertible(propertyClass, declaredItemClass))
				{
					messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "Bracket argument must be of type "+declaredItemClass.getName()+".");
					return false;
				}
				
				// --- get precise return class
				if(returnType instanceof Class<?>){
					returnClass = (Class<?>)returnType;
				}else if(returnType instanceof ParameterizedType){
					returnClass = (Class<?>)((ParameterizedType)returnType).getRawType();
				}
			}
			return true;
		}
		else
		{
			messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "Object type does not support [] access: "+objClass.getName());
			return false;
		}
	}
	public Object invoke(IEvaluationContext iContext) throws Exception
	{
		Object obj = prefix.invoke(iContext);
		Object arg = property.invoke(iContext);
		
		if(obj == null)
		{
			throw new ExpressionEvaluationException(this, "prefix object is null.");
		}
		else if(obj.getClass().isArray())
		{
			// --- item must be of type int.
			try
			{
				int index = converter.convert(arg, Integer.class).intValue();
				return Array.get(obj, index);
			}
			catch(Exception e)
			{
				throw new ExpressionEvaluationException(this, e);
			}
		}
		else if(obj instanceof List<?>)
		{
			// --- item must be of type int
			try
			{
				int index = converter.convert(arg, Integer.class).intValue();
				return ((List<?>)obj).get(index);
			}
			catch(Exception e)
			{
				throw new ExpressionEvaluationException(this, e);
			}
		}
		else if(obj instanceof Map<?,?>)
		{
			// --- item can be of any type
			// TODO: convert key
			return ((Map<?,?>)obj).get(arg);
		}
		else
		{
			throw new ExpressionEvaluationException(this, "Object type does not support []: "+obj.getClass().getName());
		}
	}
	public Class<?> getType()
	{
		return returnClass;
	}
	public Type getGenericType()
	{
	    return returnType;
	}
	public void set(IEvaluationContext iContext, Object iValue) throws ExpressionEvaluationException
	{
		//TODO?
	}
	public boolean isStaticValue()
	{
		return false;
	}
	public boolean isReadOnly()
	{
		//TODO?
	    return true;
	}
	@Override
	protected void appendExpressionString(StringBuilder builder)
	{
		prefix.appendExpressionString(builder);
		builder.append('[');
		property.appendExpressionString(builder);
		builder.append(']');
	}
	@Override
	protected void appendValuePattern(StringBuilder builder)
	{
		RegExpBuilder.appendTypeExpr(builder, getGenericType());
	}
}
