package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;

import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.ICompilationMessage;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;


public class AstChoice extends AstRightValue
{
	private ITypeConverter converter;
	private final AstNode question, yes, no;
	private Class<?> returnType;

	public AstChoice(int position, AstNode question, AstNode yes, AstNode no)
	{
		super(position);
		this.question = question;
		this.yes = yes;
		this.no = no;
	}

	public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages)
	{
		this.converter = converter;
		
		// --- 1: compile children
		boolean compiled = question.compile(converter, ctx, messages);
		compiled = yes.compile(converter, ctx, messages) && compiled;
		compiled = no.compile(converter, ctx, messages) && compiled;

		// --- 2: compile this (check types)
		if (!converter.isConvertible(question.getType(), Boolean.class))
		{
			messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "Question cannot be avaluated as a boolean.");
			return false;
		}
		Class<?> t1 = yes.getType();
		Class<?> t2 = no.getType();
		if (converter.isConvertible(t2, t1))
		{
			returnType = t1;
		}
		else if (converter.isConvertible(t1, t2))
		{
			returnType = t2;
		}
		else
		{
			messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "The 2 cases return type are not compatible.");
			return false;
		}
		return true;
	}

	public Class<?> getType()
	{
		return returnType;
	}

	public Type getGenericType()
	{
		return returnType;
	}

	public Object invoke(IEvaluationContext context) throws Exception
	{
		Object questionResult = question.invoke(context);
		boolean res;
		try
		{
			res = converter.convert(questionResult, Boolean.class);
		}
		catch (Exception e)
		{
			throw new ExpressionEvaluationException(this, e);
		}
		return res ? yes.invoke(context) : no.invoke(context);
	}

	public boolean isStaticValue()
	{
		return question.isStaticValue() && yes.isStaticValue() && no.isStaticValue();
	}

	@Override
	protected void appendExpressionString(StringBuilder builder)
	{
		question.appendExpressionString(builder);
		builder.append(" ? ");
		yes.appendExpressionString(builder);
		builder.append(" : ");
		no.appendExpressionString(builder);
	}

	@Override
	protected void appendValuePattern(StringBuilder builder)
	{
		builder.append("{");
		yes.appendValuePattern(builder);
		builder.append("|");
		no.appendValuePattern(builder);
		builder.append("}");
	}
}
