/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;
import java.util.List;

import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;


public class AstComposite extends AstRightValue
{
	private ITypeConverter converter;
	private final List<AstNode> nodes;

	public AstComposite(int position, List<AstNode> nodes)
	{
		super(position);
		this.nodes = nodes;
	}

	public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages)
	{
		this.converter = converter;
		
		boolean compiled = true;
		
		for (AstNode child : nodes){
			compiled = child.compile(converter, ctx, messages) && compiled;
		}
		
		return compiled;
	}

	public Type getGenericType()
	{
		return String.class;
	}

	public Class<?> getType()
	{
		return String.class;
	}

	public boolean isStaticValue()
	{
		for (AstNode child : nodes)
		{
			if (!child.isStaticValue()){
				return false;
			}
		}
		return true;
	}

	public Object invoke(IEvaluationContext context) throws Exception
	{
		StringBuilder b = new StringBuilder(16);
		
		for (AstNode child : nodes){
			b.append(converter.convert(child.invoke(context), String.class));
		}
		
		return b.toString();
	}

	@Override
	protected void appendExpressionString(StringBuilder builder)
	{
		for (AstNode child : nodes){
			child.appendExpressionString(builder);
		}
	}

	@Override
	protected void appendValuePattern(StringBuilder builder)
	{
		for (AstNode child : nodes){
			child.appendValuePattern(builder);
		}
	}
}
