package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.ICompilationMessage;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.ParameterizedTypeNoVariable;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;



public class AstDot extends AstProperty {
	protected final String property;
	
	private static final Object[] NO_ARG = new Object[]{};
	private static final Class<?>[] GET_SIGNATURE = {};
	
	private ITypeConverter converter;
	private Field field;
	private Method get;
	private Method set;
	private Type genType;
	private boolean isArrayLength = false;

	public AstDot(int position, AstNode base, String property, boolean lvalue) {
		super(position, base, lvalue);
		this.property = property;
	}
	public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages)
	{
		this.converter = converter;
		
		// --- 1: compile prefix
		boolean compiled = prefix.compile(converter, ctx, messages);
		
		if(!compiled){
			return false;
		}
		
		// --- 2: compile property
		Class<?> objType = prefix.getType();
		
		// --- look for get method
		String getMethodName = "get"+(Character.toUpperCase(property.charAt(0)))+(property.substring(1));
		try
        {
            get = objType.getMethod(getMethodName, GET_SIGNATURE);
        }
        catch(Exception e)
        {
        	// --- try the is<attribute> signature (for a boolean only)
        	String isMethodName = "is"+(Character.toUpperCase(property.charAt(0)))+(property.substring(1));
    		try
            {
                get = objType.getMethod(isMethodName, GET_SIGNATURE);
                
                // --- method found: return type must be boolean (with this signature)
                if(get.getReturnType() != Boolean.class && get.getReturnType() != Boolean.TYPE)
                {
					messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "The 'is' getter signature is only allowed for boolean type attributes.");
					return false;
                }
            }
            catch(Exception e1)
            {
            	// --- try to find a field
            	try
				{
					field = objType.getField(property);
				}
				catch (Exception e2)
				{
					// --- special cases: 'length' for an array
					if(objType.isArray() && "length".equals(property)){
						isArrayLength = true;
					} else	{
						messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "No such attribute: '"+property+"' (neither "+getMethodName+" nor "+isMethodName+", nor "+property+" field on object "+objType.getName()+").");
						return false;
					}
				}
            }
        }
		// --- test getter can be accessed
        if(get != null)
        {
        	// --- getter method
			if((get.getModifiers() & Modifier.PUBLIC) == 0)
			{
				messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "Getter method is not public: "+get);
				return false;
			}
	
	        // --- now look for set method
			String setMethodName = "set"+(Character.toUpperCase(property.charAt(0)))+(property.substring(1));
	       	try
	        {
		        set = objType.getMethod(setMethodName, new Class[]{get.getReturnType()});
	        }
	        catch(Exception e)
	        {
	        	// --- nevermind
	        }
			if(set != null && (set.getModifiers() & Modifier.PUBLIC) == 0)
			{
				// --- set method not accessible (Warning ?)
				messages.addMessage(this, ICompilationMessage.WARNING_LEVEL, "Setter method is not public: "+set);
				set = null;
			}
        }
        else if(field != null)
        {
        	// --- getter field
			if((field.getModifiers() & Modifier.PUBLIC) == 0)
			{
				messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "Field not public: "+field);
				return false;
			}
        }
        return true;
	}
	public Object invoke(IEvaluationContext iContext) throws Exception
	{
		Object obj = prefix.invoke(iContext);
		if(get != null)
		{
			try
			{
				return get.invoke(obj, NO_ARG);
			}
			catch(InvocationTargetException e)
			{
				// --- exception sent by the invoked method: rethrow
	        	if(e.getTargetException() instanceof Exception){
	        		throw (Exception)e.getTargetException();
	        	}
	        	
	        	if(e.getTargetException() instanceof Error){
	        		throw (Error)e.getTargetException();
	        	}
	        	
				throw e;
			}
			catch(Exception e)
			{
				throw new ExpressionEvaluationException(this, e);
			}
		}
		else if(field != null)
		{
			try
			{
				return field.get(obj);
			}
			catch(Exception e)
			{
				throw new ExpressionEvaluationException(this, e);
			}
		}
		else if(isArrayLength)
		{
			return Array.getLength(obj);
		}
		return null;
	}
	public Type getGenericType()
	{
//		if(get != null)
//			return get.getGenericReturnType();
//		else if(field != null)
//			return field.getGenericType();
//		else if(isArrayLength)
//			return Integer.TYPE;
//		return null;
		if(genType == null)
		{
			if(get != null){
				genType = get.getGenericReturnType();
			}else if(field != null){
				genType = field.getGenericType();
			}else if(isArrayLength){
				genType = Integer.TYPE;
			}else{
				return null;
			}
			// this is a hack to replace TypeVariable with real type declaration from parent type
			if(genType instanceof ParameterizedType && prefix.getGenericType() instanceof ParameterizedType){
				genType = ParameterizedTypeNoVariable.getNoVariable((ParameterizedType)genType, (ParameterizedType)prefix.getGenericType());
			}
		}
		return genType;
	}
	public Class<?> getType()
	{
		if(get != null){
			return get.getReturnType();
		}else if(field != null){
			return field.getType();
		}else if(isArrayLength){
			return Integer.TYPE;
		}
		
		return null;
	}
	public boolean isStaticValue()
	{
		return false;
	}
	public boolean isReadOnly()
	{
//		if(get != null)
//			return set != null;
		if(set != null){
			return false;
		}else if(field != null){
			return false;
		}else if(isArrayLength){
			return true;
		}
		
		return true;
	}
	public void set(IEvaluationContext iContext, Object iValue) throws Exception
	{
		if(isReadOnly()){
			//TODO: exception
			return;
		}
		
		// --- evaluate prefix
		Object obj = prefix.invoke(iContext);
		
		// --- convert value
		Class<?> type = getType();
		iValue = converter.convert(iValue, type);
		
		if(set != null)
		{
			try
			{
				set.invoke(obj, new Object[]{iValue});
			}
			catch(InvocationTargetException e)
			{
	        	if(e.getTargetException() instanceof Exception){
	        		throw (Exception)e.getTargetException();
	        	}
	        	
	        	if(e.getTargetException() instanceof Error){
	        		throw (Error)e.getTargetException();
	        	}
	        	
				throw e;
			}
			catch(Exception e)
			{
				throw new ExpressionEvaluationException(this, e);
			}
		}
		else if(field != null)
		{
			try
			{
				field.set(obj, iValue);
			}
			catch(Exception e)
			{
				throw new ExpressionEvaluationException(this, e);
			}
		}
	}
	@Override
	protected void appendExpressionString(StringBuilder builder)
	{
		prefix.appendExpressionString(builder);
		builder.append('.');
		builder.append(property);
	}
	@Override
	protected void appendValuePattern(StringBuilder builder)
	{
		RegExpBuilder.appendTypeExpr(builder, getGenericType());
	}

}
