package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;

import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;


public final class AstEval extends AstNode
{
	private final AstNode child;
	private final boolean deferred;

	public AstEval(int position, AstNode child, boolean deferred)
	{
		super(position);
		this.child = child;
		this.deferred = deferred;
	}

	public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages)
	{
		return child.compile(converter, ctx, messages);
	}

	public boolean isDeferred()
	{
		return deferred;
	}

	public Type getGenericType()
	{
		return child.getGenericType();
	}

	public Class<?> getType()
	{
		return child.getType();
	}

	@Override
	protected void appendExpressionString(StringBuilder b)
	{
		b.append(deferred ? "#{" : "${");
		child.appendExpressionString(b);
		b.append("}");
	}

	@Override
	protected void appendValuePattern(StringBuilder b)
	{
		child.appendValuePattern(b);
	}

	public Object invoke(IEvaluationContext context) throws Exception
	{
		return child.invoke(context);
	}

	public boolean isReadOnly()
	{
		return child.isReadOnly();
	}

	public boolean isStaticValue()
	{
		return child.isStaticValue();
	}

	public void set(IEvaluationContext context, Object value) throws Exception
	{
		child.set(context, value);
	}
}
