package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.ICompilationMessage;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.IExpression;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.ICompilationContext.ICompilationLogger;
import org.ow2.opensuit.cel.ICompilationContext.IFunctionContext;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;


public class AstFunction extends AstInvocation
{
	private static final IExpression[] EXPR_ARRAY_TYPE = {};

	protected IFunctionContext function;

	public AstFunction(int position, String name, List<AstNode> nodes)
	{
		super(position, name, nodes);
	}

	public boolean compile(ITypeConverter converter, ICompilationContext context, final ICompilationResultWriter messages)
	{
		if(!super.compile(converter, context, messages)){
			return false;
		}
		
		// --- find method
		// Class[] argTypes = getArgTypes();

		String fnPrefix = null;
		String fnName = name;
		int idxColon = name.indexOf(':');
		if (idxColon >= 0)
		{
			fnPrefix = name.substring(0, idxColon);
			fnName = name.substring(idxColon + 1);
		}
		List<IFunctionContext> functions = context.getFunctions(fnPrefix, fnName);

		if (functions == null || functions.size() == 0)
		{
			messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "No function '" + name + "' declared.");
			return false;
		}
		// --- find the best method
		for (int i = 0; i < functions.size(); i++)
		{
			Method m = functions.get(i).getMethod();
			if (matchesParamTypes(m))
			{
				function = functions.get(i);
				break;
			}
		}
		// --- if no method found: throw an exception
		if (function == null)
		{
			StringBuilder sb = new StringBuilder();
			sb.append("No function method matching parameter types: ");
			sb.append(name);
			sb.append("(");
			if (args != null)
			{
				for (int i = 0; i < args.size(); i++)
				{
					if (i > 0){
						sb.append(", ");
					}
					
					sb.append(args.get(i).getType().getName());
				}
			}
			sb.append(")");
			messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, sb.toString());
			return false;
		}
		// --- test method is static
		/*
		 * No if((function.getMethod().getModifiers() & Modifier.STATIC) == 0) {
		 * messages.addMessage(this, ICompilationMessage.ERROR_LEVEL,
		 * "Function method is not static: "+method); }
		 */
		// --- test method can be accessed
		if ((function.getMethod().getModifiers() & Modifier.PUBLIC) == 0)
		{
			messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "Function method is not public: " + function.getMethod());
		}
		// --- compile
		// why ?
		List<IExpression> argExpr = new ArrayList<IExpression>(args);
		function.compile(argExpr, new ICompilationLogger() {
			public void addMessage(int level, String message)
			{
				messages.addMessage(AstFunction.this, level, message);
			}
		});
		// TODO: return false if function compilation failed
		return true;
	}

	public Class<?> getType()
	{
		return function == null ? null : function.getMethod().getReturnType();
	}

	public Type getGenericType()
	{
		return function == null ? null : function.getMethod().getGenericReturnType();
	}

	public boolean isStaticValue()
	{
		// TODO: depends on the function itself
		return false;
	}

	public Object invoke(IEvaluationContext context) throws Exception
	{
		Object obj = context.getFunctionObject(function);
		return invoke(context, function.getMethod(), obj);
	}

	@Override
	protected void appendExpressionString(StringBuilder b)
	{
		b.append(name);
		b.append("(");
		if (args != null)
		{
			for (int i = 0; i < args.size(); i++)
			{
				if (i > 0){
					b.append(", ");
				}
				
				args.get(i).appendExpressionString(b);
			}
		}
		b.append(")");
	}

	@Override
	protected void appendValuePattern(StringBuilder builder)
	{
		List<IExpression> argExpr = new ArrayList<IExpression>(args);
		String valuePattern = function.getValuePattern(argExpr);
		if(valuePattern != null){
			builder.append(valuePattern);
		}else{
			RegExpBuilder.appendTypeExpr(builder, getGenericType());
		}
	}

}
