package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;

import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.ICompilationMessage;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.ICompilationContext.UnresolvedVariableError;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;


public class AstIdentifier extends AstNode
{
	private final String name;
	// private final int index;
	private Class<?> varClass;
	private Type varType;

	public AstIdentifier(int position, String name/* , int index */)
	{
		super(position);
		this.name = name;
		// this.index = index;
	}

	public String getName()
	{
		return name;
	}

	public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages)
	{
		try
		{
			varClass = ctx.getVariableType(name);
			varType = ctx.getVariableGenericType(name);
			if (varType == null)
			{
				messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "No such object: '" + name + "'.");
				return false;
			}
			return true;
		}
		catch (UnresolvedVariableError e)
		{
			messages.addMessage(this, ICompilationMessage.WARNING_LEVEL, "Unresolved object: '" + name + "'.");
			return false;
		}
	}

	public Type getGenericType()
	{
		return varType;
	}

	public Class<?> getType()
	{
		return varClass;
	}

	public Object invoke(IEvaluationContext context) throws ExpressionEvaluationException
	{
		try
		{
			return context.getVariable(name);
		}
		catch (Exception e)
		{
			throw new ExpressionEvaluationException(this, e);
		}
	}

	public boolean isReadOnly()
	{
		return true;
	}

	public boolean isStaticValue()
	{
		return false;
	}

	@Override
	protected void appendExpressionString(StringBuilder builder)
	{
		builder.append(name);
	}

	@Override
	protected void appendValuePattern(StringBuilder builder)
	{
		RegExpBuilder.appendTypeExpr(builder, getGenericType());
	}

	public void set(IEvaluationContext context, Object value) throws ExpressionEvaluationException
	{
		// TODO: exception?
	}
}
