package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;


public abstract class AstInvocation extends AstRightValue
{
	protected ITypeConverter converter;
	protected final List<AstNode> args;
	protected final String name;

	public AstInvocation(int position, String name, List<AstNode> args)
	{
		super(position);
		this.name = name;
		this.args = args;
	}
	
	public boolean compile(ITypeConverter converter, ICompilationContext context, ICompilationResultWriter results)
	{
		this.converter = converter;
		
		// --- compile args
		boolean compiled = true;
		if (args != null)
		{
			for (AstNode child : args){
				compiled = child.compile(converter, context, results) && compiled;
			}
		}
		return compiled;
	}

	/*
	 * protected Class[] getArgTypes() { int nbArgs = args == null ? 0 :
	 * args.size(); Class[] argTypes = new Class[nbArgs]; for(int i=0; i<nbArgs;
	 * i++) argTypes[i] = args.get(i).getType(); return argTypes; }
	 */
	protected boolean matchesParamTypes(Method method/* , Class[] argTypes */)
	{
		Class<?>[] methodArgTypes = method.getParameterTypes();
		int nbArgs = args == null ? 0 : args.size();
		if (method.isVarArgs())
		{
			if (nbArgs < methodArgTypes.length - 1){
				return false;
			}
			
			// --- test the first (L-1) arguments
			for (int j = 0; j < methodArgTypes.length - 1; j++)
			{
				if (!converter.isConvertible(args.get(j).getType(), methodArgTypes[j]))
				{
					// --- does not match
					return false;
				}
			}
			// --- now check that all remaining arguments are compatible with
			// var arg type
			Class<?> methodVarArgType = methodArgTypes[methodArgTypes.length - 1].getComponentType();
			for (int j = methodArgTypes.length - 1; j < nbArgs; j++)
			{
				if (!converter.isConvertible(args.get(j).getType(), methodVarArgType))
				{
					// --- does not match
					return false;
				}
			}
			return true;
		}
		else
		{
			if (methodArgTypes.length != nbArgs){
				return false;
			}
			
			for (int j = 0; j < methodArgTypes.length; j++)
			{
				if (!converter.isConvertible(args.get(j).getType(), methodArgTypes[j]))
				{
					// --- does not match
					return false;
				}
			}
			return true;
		}
	}

	protected Object invoke(IEvaluationContext context, Method method, Object obj) throws Exception
	{
		try
		{
			Object[] argsArray = null;
			// --- TODO: check args number matches the method param types
			// --- convert types and build the VarArg array
			if (args != null)
			{
				Class<?>[] methodArgTypes = method.getParameterTypes();
				
				if (method.isVarArgs())
				{
					argsArray = new Object[methodArgTypes.length];
					// --- convert the first (L-1) arguments
					for (int i = 0; i < methodArgTypes.length - 1; i++)
					{
						Object argVal = args.get(i).invoke(context);
						try
						{
							argsArray[i] = converter.convert(argVal, methodArgTypes[i]);
						}
						catch (Exception e)
						{
							throw new ExpressionEvaluationException(this, e);
						}
					}

					// --- then build and convert varargs
					Class<?> methodVarArgType = methodArgTypes[methodArgTypes.length - 1].getComponentType();
					
					Object varArgs = Array.newInstance(methodVarArgType, args.size() - methodArgTypes.length + 1);
					
					for (int j = methodArgTypes.length - 1; j < args.size(); j++)
					{
						Array.set(varArgs, j - methodArgTypes.length + 1, converter.convert(args.get(j).invoke(context), methodVarArgType));
					}
					argsArray[methodArgTypes.length - 1] = varArgs;
				}
				else
				{
					argsArray = new Object[methodArgTypes.length];
					
					for (int i = 0; i < methodArgTypes.length; i++){
						argsArray[i] = converter.convert(args.get(i).invoke(context), methodArgTypes[i]);
					}
				}
			}
			return method.invoke(obj, argsArray);
		}
		catch (InvocationTargetException e)
		{
			// --- call was ok, we cannot wrap this exception
			// throw new ExpressionEvaluationException(this,
			// e.getTargetException());
			if (e.getTargetException() instanceof Exception){
				throw (Exception) e.getTargetException();
			}
			
			if (e.getTargetException() instanceof Error){
				throw (Error) e.getTargetException();
			}
			
			throw e;
		}
		catch (Exception e)
		{
			// --- any other exception is wrapped
			throw new ExpressionEvaluationException(this, e);
		}
	}
}
