package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.ICompilationMessage;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.ParameterizedTypeNoVariable;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;



public class AstMethod extends AstInvocation
{
	protected final AstNode prefix;
	protected Method method;
	private Type genType;

	public AstMethod(int position, AstNode prefix, String name, List<AstNode> args)
	{
		super(position, name, args);
		this.prefix = prefix;
	}
	public boolean compile(ITypeConverter converter, ICompilationContext context, ICompilationResultWriter messages)
	{
		// --- compile prefix and args (in super)
		boolean compiled = super.compile(converter, context, messages);
		compiled = prefix.compile(converter, context, messages) && compiled;
		
		if(!compiled){
			return false;
		}
		
		// --- find method
		Class<?> objType = prefix.getType();
		
		int nbArgs = args == null ? 0 : args.size();
		Class<?>[] argTypes = new Class[nbArgs];
		
		for(int i=0; i<nbArgs; i++){
			argTypes[i] = args.get(i).getType();
		}
		
		// --- 1: look for method with exact argument types
		try
		{
			method = objType.getMethod(name, argTypes);
		}
		catch (Exception e)
		{
		}
		
		// --- 2: look for method with compatible argument types
		if(method == null)
		{
	        java.lang.reflect.Method[] methods = objType.getMethods();
			for(int i=0; i<methods.length; i++)
			{
				if(methods[i].getName().equals(name))
				{
					if(matchesParamTypes(methods[i]))
					{
						method = methods[i];
						break;
					}
				}
			}
		}
		
		// --- if no method found: throw an exception
		if(method == null)
		{
			StringBuilder sb = new StringBuilder();
			sb.append("No such method: ");
			sb.append(objType.getName());
			sb.append(".");
			sb.append(name);
			sb.append("(");
			if(args != null)
			{
				for(int i=0; i<args.size(); i++)
				{
					if(i > 0){
						sb.append(", ");
					}
					
					sb.append(args.get(i).getType().getName());
				}
			}
			sb.append(")");
			messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, sb.toString());
			return false;
		}
		// --- test method can be accessed
		if((method.getModifiers() & Modifier.PUBLIC) == 0)
		{
			messages.addMessage(this, ICompilationMessage.ERROR_LEVEL, "Method is not public: "+method);
			return false;
		}
		return true;
	}
	public Class<?> getType()
	{
		return method == null ? null : method.getReturnType();
	}
	public Type getGenericType()
	{
		if(method == null){
			return null;
		}
		
		if(genType == null)
		{
			genType = method.getGenericReturnType();
			// this is a hack to replace TypeVariable with real type declaration from parent type
			if(genType instanceof ParameterizedType && prefix.getGenericType() instanceof ParameterizedType){
				genType = ParameterizedTypeNoVariable.getNoVariable((ParameterizedType)genType, (ParameterizedType)prefix.getGenericType());
			}
		}
		return genType;
//		return method.getGenericReturnType();
	}
	public boolean isStaticValue()
	{
		return false;
	}
	public Object invoke(IEvaluationContext context) throws Exception
	{
		Object obj = prefix.invoke(context);
		return invoke(context, method, obj);
	}
	@Override
	protected void appendExpressionString(StringBuilder b)
	{
		prefix.appendExpressionString(b);
		b.append(".");
		b.append(name);
		b.append("(");
		if (args != null)
		{
			for (int i = 0; i < args.size(); i++)
			{
				if(i > 0){
					b.append(", ");
				}
				
				args.get(i).appendExpressionString(b);
			}
		}
		b.append(")");
	}
	@Override
	protected void appendValuePattern(StringBuilder builder)
	{
		RegExpBuilder.appendTypeExpr(builder, getGenericType());
	}

}
