package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;

import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;


public final class AstNested extends AstRightValue
{
	private final AstNode child;

	public AstNested(int position, AstNode child)
	{
		super(position);
		this.child = child;
	}

	public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages)
	{
		return child.compile(converter, ctx, messages);
	}

	public Class<?> getType()
	{
		return child.getType();
	}

	public Type getGenericType()
	{
		return child.getGenericType();
	}

	public Object invoke(IEvaluationContext context) throws Exception
	{
		return child.invoke(context);
	}

	public boolean isStaticValue()
	{
		return child.isStaticValue();
	}

	@Override
	protected void appendExpressionString(StringBuilder b)
	{
		b.append("(");
		child.appendExpressionString(b);
		b.append(")");
	}

	@Override
	protected void appendValuePattern(StringBuilder builder)
	{
		child.appendValuePattern(builder);
	}
}
