package org.ow2.opensuit.cel.impl.tree.impl.ast;

import org.ow2.opensuit.cel.impl.tree.IExprNode;

public abstract class AstNode implements IExprNode
{
	protected int position;

	public AstNode(int position)
	{
		this.position = position;
	}

	/**
	 * Builds the expression outer string form.
	 * This methods makes a StringBuilder and calls recursively appendExpressionString()
	 * on each child node.
	 */
	public final String getExpressionString()
	{
		StringBuilder builder = new StringBuilder();
		appendExpressionString(builder);
		return builder.toString();
	}
	/**
	 * Recursive method to build an expression string form.
	 * @param builder
	 */
	protected abstract void appendExpressionString(StringBuilder builder);
	/**
	 * Builds the returned values regular expression.
	 * This methods makes a StringBuilder and calls recursively appendValuePattern()
	 * on each child node.
	 */
	public final String getValuePattern()
	{
		StringBuilder builder = new StringBuilder();
		appendValuePattern(builder);
		return builder.toString();
	}
	/**
	 * Recursive method to build the returned values regular expression.
	 * This is used for advanced validation.
	 * @param builder
	 */
	protected abstract void appendValuePattern(StringBuilder builder);

	@Override
	public final String toString()
	{
		return getExpressionString();
	}
	/**
	 * Returns the node's start position (character)
	 * in the original expression string.
	 */
	public final int getPosition()
	{
		return position;
	}
}
