package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;

import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;


public final class AstNull extends AstLiteral
{

	public AstNull(int position)
	{
		super(position);
	}

	public Object invoke(IEvaluationContext context) throws ExpressionEvaluationException
	{
		return null;
	}

	public Class<?> getType()
	{
		return Object.class;
	}

	public Type getGenericType()
	{
		return Object.class;
	}

	@Override
	protected void appendExpressionString(StringBuilder builder)
	{
		builder.append("null");
	}

	@Override
	protected void appendValuePattern(StringBuilder builder)
	{
		builder.append("null");
	}
}
