package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;

import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;


public final class AstNumber extends AstLiteral
{
	private final Number value;

	public AstNumber(int position, Number value)
	{
		super(position);
		this.value = value;
	}

	public Object invoke(IEvaluationContext context) throws ExpressionEvaluationException
	{
		return value;
	}

	public Class<?> getType()
	{
		return value.getClass();
	}

	public Type getGenericType()
	{
		return value.getClass();
	}

	@Override
	protected void appendExpressionString(StringBuilder builder)
	{
		builder.append(value);
	}

	@Override
	protected void appendValuePattern(StringBuilder builder)
	{
		RegExpBuilder.appendString(builder, String.valueOf(value));
	}
}
