package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;

import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;


public final class AstString extends AstLiteral
{
	private final String value;

	public AstString(int position, String value)
	{
		super(position);
		this.value = value;
	}

	public Object invoke(IEvaluationContext context) throws ExpressionEvaluationException
	{
		return value;
	}

	public Class<?> getType()
	{
		return String.class;
	}

	public Type getGenericType()
	{
		return String.class;
	}

	@Override
	protected void appendExpressionString(StringBuilder b)
	{
		b.append("'");
		int length = value.length();
		for (int i = 0; i < length; i++)
		{
			char c = value.charAt(i);
			
			if (c == '\\' || c == '\''){
				b.append('\\');
			}
			
			b.append(c);
		}
		b.append("'");
	}

	@Override
	protected void appendValuePattern(StringBuilder builder)
	{
//		builder.append(value);
		RegExpBuilder.appendString(builder, value);
	}
}
