package org.ow2.opensuit.cel.impl.tree.impl.ast;

import java.lang.reflect.Type;

import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.misc.RegExpBuilder;
import org.ow2.opensuit.cel.impl.tree.ExpressionEvaluationException;


public final class AstText extends AstNode
{
	private final String value;

	public AstText(int position, String value)
	{
		super(position);
		this.value = value;
	}

	public boolean compile(ITypeConverter converter, ICompilationContext ctx, ICompilationResultWriter messages)
	{
		return true;
	}

	public Class<?> getType()
	{
		return String.class;
	}

	public Type getGenericType()
	{
		return String.class;
	}

	public boolean isReadOnly()
	{
		return true;
	}

	public boolean isStaticValue()
	{
		return true;
	}

	public Object invoke(IEvaluationContext context) throws ExpressionEvaluationException
	{
		return value;
	}

	public void set(IEvaluationContext context, Object value) throws ExpressionEvaluationException
	{
		// TODO Auto-generated method stub
	}

	@Override
	protected void appendExpressionString(StringBuilder b)
	{
		int end = value.length() - 1;
		for (int i = 0; i < end; i++)
		{
			char c = value.charAt(i);
			
			if ((c == '#' || c == '$') && value.charAt(i + 1) == '{'){
				b.append('\\');
			}
			
			b.append(c);
		}
		
		if (end >= 0){
			b.append(value.charAt(end));
		}
	}

	@Override
	protected void appendValuePattern(StringBuilder builder)
	{
		RegExpBuilder.appendString(builder, value);
	}
}
