/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ow2.opensuit.cel.util;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.ow2.opensuit.cel.ICompilationContext;
import org.ow2.opensuit.cel.IExpression;


public class SimpleCompilationContext implements ICompilationContext
{
	private HashMap<String, Class<?>> name2class = new HashMap<String, Class<?>>();
	private HashMap<String, List<IFunctionContext>> name2function = new HashMap<String, List<IFunctionContext>>();
	
	public void declareVariable(String name, Class<?> clazz)
	{
		name2class.put(name, clazz);
	}
	public void declareFunction(String prefix, String name, Method function)
	{
		String fullName = prefix == null || prefix.length() == 0 ? name : prefix+":"+name;
		List<IFunctionContext> list = name2function.get(fullName);
		if(list == null)
		{
			list = new ArrayList<IFunctionContext>(1);
			name2function.put(fullName, list);
		}
		else if(list.contains(function))
		{
			return;
		}
		// --- add
		list.add(new FunctionContextImpl(function));
	}
	// ======================================================================
	// === ICompilationContext implementation
	// ======================================================================
	public Type getVariableGenericType(String name) throws UnresolvedVariableError
	{
		return name2class.get(name);
	}
	public Class<?> getVariableType(String name) throws UnresolvedVariableError
	{
		return name2class.get(name);
	}
	public List<IFunctionContext> getFunctions(String prefix, String name)
	{
		String fullName = prefix == null || prefix.length() == 0 ? name : prefix+":"+name;
		return name2function.get(fullName);
	}
	private static class FunctionContextImpl implements IFunctionContext
	{
		private Method method;
		
		public FunctionContextImpl(Method method)
		{
			this.method = method;
		}
		public Method getMethod()
		{
			return method;
		}
		public void compile(List<IExpression> arguments, ICompilationLogger logger)
		{
		}
		public String getValuePattern(List<IExpression> arguments)
		{
			return null;
		}
	}
}
