/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ow2.opensuit.cel.util;

import java.lang.reflect.Method;
import java.util.HashMap;

import org.ow2.opensuit.cel.IEvaluationContext;
import org.ow2.opensuit.cel.ICompilationContext.IFunctionContext;


public class SimpleEvaluationContext implements IEvaluationContext
{
	private HashMap<String, Object> name2obj = new HashMap<String, Object>();
	private HashMap<Method, Object> method2obj = new HashMap<Method, Object>();
	
	public void setVariable(String name, Object obj)
	{
		name2obj.put(name, obj);
	}
	public void setFunctionHandler(String prefix, String name, Object obj, Method function)
	{
		method2obj.put(function, obj);
	}
	// ======================================================================
	// === IEvaluationContext implementation
	// ======================================================================
	public Object getVariable(String name)
	{
		return name2obj.get(name);
	}
	public Object getFunctionObject(IFunctionContext function)
	{
		return method2obj.get(function.getMethod());
	}
}
