/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ow2.opensuit.cel.ICompilationMessage;
import org.ow2.opensuit.cel.IExpression;
import org.ow2.opensuit.cel.impl.ICompilationResultWriter;
import org.ow2.opensuit.cel.impl.tree.IExprNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationResult
implements ICompilationResultWriter {
    private IExpression expression;
    private List<ICompilationMessage> messages = Collections.emptyList();

    @Override
    public IExpression getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(IExpression expression) {
        this.expression = expression;
    }

    @Override
    public List<ICompilationMessage> getMessages() {
        return this.messages;
    }

    @Override
    public boolean hasErrors() {
        for (ICompilationMessage m : this.messages) {
            if (m.getLevel() != 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addMessage(IExprNode node, int level, String message) {
        this.addMessage(node.getPosition(), level, message);
    }

    @Override
    public void addMessage(int position, int level, String message) {
        if (this.messages.size() == 0) {
            this.messages = new ArrayList<ICompilationMessage>(1);
        }
        this.messages.add(new MessageImpl(position, level, message));
    }

    private static class MessageImpl
    implements ICompilationMessage {
        private int position;
        private int level;
        private String message;

        public MessageImpl(int position, int level, String message) {
            this.position = position;
            this.level = level;
            this.message = message;
        }

        public int getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

