/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.misc;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.ow2.opensuit.cel.ITypeConverter;
import org.ow2.opensuit.cel.impl.misc.LocalMessages;
import org.ow2.opensuit.cel.util.ConversionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberOperations {
    private static final Long LONG_ZERO = 0L;

    private static final boolean isFloatOrDouble(Object value) {
        return value instanceof Float || value instanceof Double;
    }

    private static final boolean isBigDecimalOrBigInteger(Object value) {
        return value instanceof BigDecimal || value instanceof BigInteger;
    }

    private static final boolean isBigDecimalOrFloatOrDouble(Object value) {
        return value instanceof BigDecimal || NumberOperations.isFloatOrDouble(value);
    }

    public static boolean checkTypes(ITypeConverter converter, Class<?> c1, Class<?> c2) {
        return converter.isConvertible(c1, Number.class) && converter.isConvertible(c2, Number.class);
    }

    public static boolean checkType(ITypeConverter converter, Class<?> c) {
        return converter.isConvertible(c, Number.class);
    }

    public static Class<?> getAddReturnType(Class<?> c1, Class<?> c2) {
        if (BigDecimal.class.isAssignableFrom(c1) || BigDecimal.class.isAssignableFrom(c2)) {
            return BigDecimal.class;
        }
        if (c1 == Float.class || c1 == Float.TYPE || c1 == Double.class || c1 == Double.TYPE) {
            if (BigInteger.class.isAssignableFrom(c2)) {
                return BigDecimal.class;
            }
        } else {
            return Double.class;
        }
        if (c2 == Float.class || c2 == Float.TYPE || c2 == Double.class || c2 == Double.TYPE) {
            if (BigInteger.class.isAssignableFrom(c1)) {
                return BigDecimal.class;
            }
        } else {
            return Double.class;
        }
        if (BigInteger.class.isAssignableFrom(c1) || BigInteger.class.isAssignableFrom(c2)) {
            return BigInteger.class;
        }
        return Long.class;
    }

    public static final Number add(ITypeConverter converter, Object o1, Object o2) throws Exception {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (o1 instanceof BigDecimal || o2 instanceof BigDecimal) {
            return converter.convert(o1, BigDecimal.class).add(converter.convert(o2, BigDecimal.class));
        }
        if (NumberOperations.isFloatOrDouble(o1) || NumberOperations.isFloatOrDouble(o2)) {
            if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
                return converter.convert(o1, BigDecimal.class).add(converter.convert(o2, BigDecimal.class));
            }
            return converter.convert(o1, Double.class) + converter.convert(o2, Double.class);
        }
        if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
            return converter.convert(o1, BigInteger.class).add(converter.convert(o2, BigInteger.class));
        }
        return converter.convert(o1, Long.class) + converter.convert(o2, Long.class);
    }

    public static Class<?> getSubReturnType(Class<?> c1, Class<?> c2) {
        return NumberOperations.getAddReturnType(c1, c2);
    }

    public static final Number sub(ITypeConverter converter, Object o1, Object o2) throws Exception {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (o1 instanceof BigDecimal || o2 instanceof BigDecimal) {
            return converter.convert(o1, BigDecimal.class).subtract(converter.convert(o2, BigDecimal.class));
        }
        if (NumberOperations.isFloatOrDouble(o1) || NumberOperations.isFloatOrDouble(o2)) {
            if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
                return converter.convert(o1, BigDecimal.class).subtract(converter.convert(o2, BigDecimal.class));
            }
            return converter.convert(o1, Double.class) - converter.convert(o2, Double.class);
        }
        if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
            return converter.convert(o1, BigInteger.class).subtract(converter.convert(o2, BigInteger.class));
        }
        return converter.convert(o1, Long.class) - converter.convert(o2, Long.class);
    }

    public static Class<?> getMulReturnType(Class<?> c1, Class<?> c2) {
        return NumberOperations.getAddReturnType(c1, c2);
    }

    public static final Number mul(ITypeConverter converter, Object o1, Object o2) throws Exception {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (o1 instanceof BigDecimal || o2 instanceof BigDecimal) {
            return converter.convert(o1, BigDecimal.class).multiply(converter.convert(o2, BigDecimal.class));
        }
        if (NumberOperations.isFloatOrDouble(o1) || NumberOperations.isFloatOrDouble(o2)) {
            if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
                return converter.convert(o1, BigDecimal.class).multiply(converter.convert(o2, BigDecimal.class));
            }
            return converter.convert(o1, Double.class) * converter.convert(o2, Double.class);
        }
        if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
            return converter.convert(o1, BigInteger.class).multiply(converter.convert(o2, BigInteger.class));
        }
        return converter.convert(o1, Long.class) * converter.convert(o2, Long.class);
    }

    public static Class<?> getDivReturnType(Class<?> c1, Class<?> c2) {
        if (BigDecimal.class.isAssignableFrom(c1) || BigDecimal.class.isAssignableFrom(c2)) {
            return BigDecimal.class;
        }
        if (BigInteger.class.isAssignableFrom(c1) || BigInteger.class.isAssignableFrom(c2)) {
            return BigDecimal.class;
        }
        return Double.class;
    }

    public static final Number div(ITypeConverter converter, Object o1, Object o2) throws Exception {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (NumberOperations.isBigDecimalOrBigInteger(o1) || NumberOperations.isBigDecimalOrBigInteger(o2)) {
            return converter.convert(o1, BigDecimal.class).divide(converter.convert(o2, BigDecimal.class), 4);
        }
        return converter.convert(o1, Double.class) / converter.convert(o2, Double.class);
    }

    public static Class<?> getModReturnType(Class<?> c1, Class<?> c2) {
        return NumberOperations.getDivReturnType(c1, c2);
    }

    public static final Number mod(ITypeConverter converter, Object o1, Object o2) throws Exception {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (NumberOperations.isBigDecimalOrFloatOrDouble(o1) || NumberOperations.isBigDecimalOrFloatOrDouble(o2)) {
            return converter.convert(o1, Double.class) % converter.convert(o2, Double.class);
        }
        if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
            return converter.convert(o1, BigInteger.class).remainder(converter.convert(o2, BigInteger.class));
        }
        return converter.convert(o1, Long.class) % converter.convert(o2, Long.class);
    }

    public static final Number neg(ITypeConverter converter, Object value) throws ConversionError {
        if (value == null) {
            return LONG_ZERO;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).negate();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).negate();
        }
        if (value instanceof Double) {
            return -((Double)value).doubleValue();
        }
        if (value instanceof Float) {
            return Float.valueOf(-((Float)value).floatValue());
        }
        if (value instanceof Long) {
            return -((Long)value).longValue();
        }
        if (value instanceof Integer) {
            return -((Integer)value).intValue();
        }
        if (value instanceof Short) {
            return -((Short)value).shortValue();
        }
        if (value instanceof Byte) {
            return -((Byte)value).byteValue();
        }
        throw new ConversionError(LocalMessages.get("error.negate", value.getClass()));
    }
}

