/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.misc;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

public class RegExpBuilder {
    public static void appendTypeExpr(StringBuilder builder, Type type) {
        if (type == Boolean.class || type == Boolean.TYPE) {
            builder.append("(true|false)");
        } else if (type == Short.class || type == Short.TYPE || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == BigInteger.class) {
            builder.append("\\d+");
        } else if (type == Float.class || type == Float.TYPE || type == Double.class || type == Double.TYPE || type == BigDecimal.class) {
            builder.append("\\d*\\.?\\d+");
        } else if (type == Byte.class || type == Byte.TYPE) {
            builder.append("\\d+");
        } else if (type == Character.class || type == Character.TYPE) {
            builder.append(".");
        } else if (type instanceof Class && ((Class)type).isEnum()) {
            T[] values = ((Class)type).getEnumConstants();
            builder.append("(");
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    builder.append("|");
                }
                builder.append(values[i]);
            }
            builder.append(")");
        } else {
            builder.append(".*");
        }
    }

    public static void appendString(StringBuilder builder, String value) {
        block5: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '?': 
                case '\\': 
                case '^': 
                case '{': 
                case '}': {
                    builder.append('\\');
                    builder.append(c);
                    continue block5;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block5;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block5;
                }
                default: {
                    builder.append(c);
                }
            }
        }
    }
}

