/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.cel.impl.tree.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ow2.opensuit.cel.impl.misc.LocalMessages;
import org.ow2.opensuit.cel.impl.tree.IExprNode;
import org.ow2.opensuit.cel.impl.tree.impl.Scanner;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstBinaryOperation;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstBoolean;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstBracket;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstChoice;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstComposite;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstDot;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstEval;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstFunction;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstIdentifier;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstMethod;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNested;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNode;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNull;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstNumber;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstString;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstText;
import org.ow2.opensuit.cel.impl.tree.impl.ast.AstUnaryOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final String EXPR_FIRST = (Object)((Object)Scanner.Symbol.IDENTIFIER) + "|" + (Object)((Object)Scanner.Symbol.STRING) + "|" + (Object)((Object)Scanner.Symbol.FLOAT) + "|" + (Object)((Object)Scanner.Symbol.INTEGER) + "|" + (Object)((Object)Scanner.Symbol.TRUE) + "|" + (Object)((Object)Scanner.Symbol.FALSE) + "|" + (Object)((Object)Scanner.Symbol.NULL) + "|" + (Object)((Object)Scanner.Symbol.MINUS) + "|" + (Object)((Object)Scanner.Symbol.NOT) + "|" + (Object)((Object)Scanner.Symbol.EMPTY) + "|" + (Object)((Object)Scanner.Symbol.LPAREN);
    protected final Scanner scanner;
    private List<LookaheadToken> lookahead = Collections.emptyList();
    private Scanner.Token token;
    private int position;
    protected Map<Scanner.ExtensionToken, ExtensionHandler> extensions = Collections.emptyMap();

    public Parser(String input) {
        this.scanner = this.createScanner(input);
    }

    protected Scanner createScanner(String expression) {
        return new Scanner(expression);
    }

    public void putExtensionHandler(Scanner.ExtensionToken token, ExtensionHandler extension) {
        if (this.extensions.isEmpty()) {
            this.extensions = new HashMap<Scanner.ExtensionToken, ExtensionHandler>(16);
        }
        this.extensions.put(token, extension);
    }

    protected ExtensionHandler getExtensionHandler(Scanner.Token token) {
        return this.extensions.get(token);
    }

    protected Number parseInteger(String string) throws ParseException {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException e2) {
                this.fail(Scanner.Symbol.INTEGER);
                return null;
            }
        }
    }

    protected Number parseFloat(String string) throws ParseException {
        try {
            return Float.valueOf(string);
        }
        catch (NumberFormatException e) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException e2) {
                this.fail(Scanner.Symbol.FLOAT);
                return null;
            }
        }
    }

    protected AstBinaryOperation createAstBinary(AstNode left, AstNode right, AstBinaryOperation.Operator operator) {
        return new AstBinaryOperation(this.position, left, right, operator);
    }

    protected AstBracket createAstBracket(AstNode base, AstNode property, boolean lvalue) {
        return new AstBracket(this.position, base, property, lvalue);
    }

    protected AstChoice createAstChoice(AstNode question, AstNode yes, AstNode no) {
        return new AstChoice(this.position, question, yes, no);
    }

    protected AstComposite createAstComposite(List<AstNode> nodes) {
        return new AstComposite(this.position, nodes);
    }

    protected AstDot createAstDot(AstNode base, String property, boolean lvalue) {
        return new AstDot(this.position, base, property, lvalue);
    }

    protected AstFunction createAstFunction(String name, List<AstNode> args) {
        return new AstFunction(this.position, name, args);
    }

    protected AstIdentifier createAstIdentifier(String name) {
        return new AstIdentifier(this.position, name);
    }

    protected AstMethod createAstMethod(AstNode prefix, String name, List<AstNode> nodes) {
        return new AstMethod(this.position, prefix, name, nodes);
    }

    protected AstUnaryOperation createAstUnary(AstNode child, AstUnaryOperation.Operator operator) {
        return new AstUnaryOperation(this.position, child, operator);
    }

    protected final Scanner.Token getToken() {
        return this.token;
    }

    protected void fail(String expected) throws ParseException {
        throw new ParseException(this.position, "'" + this.token.getImage() + "'", expected);
    }

    protected void fail(Scanner.Symbol expected) throws ParseException {
        this.fail(expected.toString());
    }

    protected final Scanner.Token lookahead(int index) throws Scanner.ScanException, ParseException {
        if (this.lookahead.isEmpty()) {
            this.lookahead = new LinkedList<LookaheadToken>();
        }
        while (index >= this.lookahead.size()) {
            this.lookahead.add(new LookaheadToken(this.scanner.next(), this.scanner.getPosition()));
        }
        return this.lookahead.get((int)index).token;
    }

    protected final Scanner.Token consumeToken() throws Scanner.ScanException, ParseException {
        Scanner.Token result = this.token;
        if (this.lookahead.isEmpty()) {
            this.token = this.scanner.next();
            this.position = this.scanner.getPosition();
        } else {
            LookaheadToken next = this.lookahead.remove(0);
            this.token = next.token;
            this.position = next.position;
        }
        return result;
    }

    protected final Scanner.Token consumeToken(Scanner.Symbol expected) throws Scanner.ScanException, ParseException {
        if (this.token.getSymbol() != expected) {
            this.fail(expected);
        }
        return this.consumeToken();
    }

    public IExprNode parse() throws Scanner.ScanException, ParseException {
        this.consumeToken();
        AstNode t = this.text();
        if (this.token.getSymbol() == Scanner.Symbol.EOF) {
            if (t == null) {
                t = new AstText(this.position, "");
            }
            return t;
        }
        AstEval e = this.eval();
        if (this.token.getSymbol() == Scanner.Symbol.EOF && t == null) {
            return e;
        }
        ArrayList<AstNode> list = new ArrayList<AstNode>();
        if (t != null) {
            list.add(t);
        }
        list.add(e);
        t = this.text();
        if (t != null) {
            list.add(t);
        }
        while (this.token.getSymbol() != Scanner.Symbol.EOF) {
            if (e.isDeferred()) {
                list.add(this.eval(true, true));
            } else {
                list.add(this.eval(true, false));
            }
            if ((t = this.text()) == null) continue;
            list.add(t);
        }
        return this.createAstComposite(list);
    }

    protected AstNode text() throws Scanner.ScanException, ParseException {
        AstText v = null;
        if (this.token.getSymbol() == Scanner.Symbol.TEXT) {
            v = new AstText(this.position, this.token.getImage());
            this.consumeToken();
        }
        return v;
    }

    protected AstEval eval() throws Scanner.ScanException, ParseException {
        AstEval e = this.eval(false, false);
        if (e == null && (e = this.eval(false, true)) == null) {
            this.fail((Object)((Object)Scanner.Symbol.START_EVAL_DEFERRED) + "|" + (Object)((Object)Scanner.Symbol.START_EVAL_DYNAMIC));
        }
        return e;
    }

    protected AstEval eval(boolean required, boolean deferred) throws Scanner.ScanException, ParseException {
        Scanner.Symbol start_eval;
        AstEval v = null;
        Scanner.Symbol symbol = start_eval = deferred ? Scanner.Symbol.START_EVAL_DEFERRED : Scanner.Symbol.START_EVAL_DYNAMIC;
        if (this.token.getSymbol() == start_eval) {
            this.consumeToken();
            v = new AstEval(this.position, this.expr(true), deferred);
            this.consumeToken(Scanner.Symbol.END_EVAL);
        } else if (required) {
            this.fail(start_eval);
        }
        return v;
    }

    protected AstNode expr(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.or(required);
        if (v == null) {
            return null;
        }
        if (this.token.getSymbol() == Scanner.Symbol.QUESTION) {
            this.consumeToken();
            AstNode a = this.expr(true);
            this.consumeToken(Scanner.Symbol.COLON);
            AstNode b = this.expr(true);
            v = this.createAstChoice(v, a, b);
        }
        return v;
    }

    protected AstNode or(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.and(required);
        if (v == null) {
            return null;
        }
        block4: while (true) {
            switch (this.token.getSymbol()) {
                case OR: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.and(true), AstBinaryOperation.OR);
                    continue block4;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.OR) break block4;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.and(true));
                    continue block4;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode and(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.eq(required);
        if (v == null) {
            return null;
        }
        block4: while (true) {
            switch (this.token.getSymbol()) {
                case AND: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.eq(true), AstBinaryOperation.AND);
                    continue block4;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.AND) break block4;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.eq(true));
                    continue block4;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode eq(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.cmp(required);
        if (v == null) {
            return null;
        }
        block5: while (true) {
            switch (this.token.getSymbol()) {
                case EQ: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.cmp(true), AstBinaryOperation.EQ);
                    continue block5;
                }
                case NE: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.cmp(true), AstBinaryOperation.NE);
                    continue block5;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.EQ) break block5;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.cmp(true));
                    continue block5;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode cmp(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.add(required);
        if (v == null) {
            return null;
        }
        block7: while (true) {
            switch (this.token.getSymbol()) {
                case LT: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.add(true), AstBinaryOperation.LT);
                    continue block7;
                }
                case LE: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.add(true), AstBinaryOperation.LE);
                    continue block7;
                }
                case GE: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.add(true), AstBinaryOperation.GE);
                    continue block7;
                }
                case GT: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.add(true), AstBinaryOperation.GT);
                    continue block7;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.CMP) break block7;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.add(true));
                    continue block7;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode add(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.mul(required);
        if (v == null) {
            return null;
        }
        block5: while (true) {
            switch (this.token.getSymbol()) {
                case PLUS: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.mul(true), AstBinaryOperation.ADD);
                    continue block5;
                }
                case MINUS: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.mul(true), AstBinaryOperation.SUB);
                    continue block5;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.ADD) break block5;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.mul(true));
                    continue block5;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode mul(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.unary(required);
        if (v == null) {
            return null;
        }
        block6: while (true) {
            switch (this.token.getSymbol()) {
                case MUL: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.unary(true), AstBinaryOperation.MUL);
                    continue block6;
                }
                case DIV: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.unary(true), AstBinaryOperation.DIV);
                    continue block6;
                }
                case MOD: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.unary(true), AstBinaryOperation.MOD);
                    continue block6;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.MUL) break block6;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.unary(true));
                    continue block6;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode unary(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = null;
        switch (this.token.getSymbol()) {
            case NOT: {
                this.consumeToken();
                v = this.createAstUnary(this.unary(true), AstUnaryOperation.NOT);
                break;
            }
            case MINUS: {
                this.consumeToken();
                v = this.createAstUnary(this.unary(true), AstUnaryOperation.NEG);
                break;
            }
            case EMPTY: {
                this.consumeToken();
                v = this.createAstUnary(this.unary(true), AstUnaryOperation.EMPTY);
                break;
            }
            case EXTENSION: {
                if (this.getExtensionHandler(this.token).getExtensionPoint() == ExtensionPoint.UNARY) {
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(this.unary(true));
                    break;
                }
            }
            default: {
                v = this.value();
            }
        }
        if (v == null && required) {
            this.fail(EXPR_FIRST);
        }
        return v;
    }

    protected AstNode value() throws Scanner.ScanException, ParseException {
        boolean lvalue = true;
        AstNode v = this.nonliteral();
        if (v == null) {
            v = this.literal();
            if (v == null) {
                return null;
            }
            lvalue = false;
        }
        block4: while (true) {
            switch (this.token.getSymbol()) {
                case DOT: {
                    this.consumeToken();
                    String name = this.consumeToken(Scanner.Symbol.IDENTIFIER).getImage();
                    if (this.token.getSymbol() == Scanner.Symbol.LPAREN) {
                        this.consumeToken();
                        v = this.createAstMethod(v, name, this.list());
                        this.consumeToken(Scanner.Symbol.RPAREN);
                        continue block4;
                    }
                    v = this.createAstDot(v, name, lvalue);
                    continue block4;
                }
                case LBRACK: {
                    this.consumeToken();
                    AstNode property = this.expr(true);
                    v = this.createAstBracket(v, property, lvalue);
                    this.consumeToken(Scanner.Symbol.RBRACK);
                    continue block4;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode nonliteral() throws Scanner.ScanException, ParseException {
        AstNode v = null;
        switch (this.token.getSymbol()) {
            case IDENTIFIER: {
                String name = this.consumeToken().getImage();
                if (this.token.getSymbol() == Scanner.Symbol.COLON && this.lookahead(0).getSymbol() == Scanner.Symbol.IDENTIFIER && this.lookahead(1).getSymbol() == Scanner.Symbol.LPAREN) {
                    this.consumeToken();
                    name = name + ":" + this.token.getImage();
                    this.consumeToken();
                }
                if (this.token.getSymbol() == Scanner.Symbol.LPAREN) {
                    this.consumeToken();
                    List<AstNode> args = this.list();
                    this.consumeToken(Scanner.Symbol.RPAREN);
                    v = this.function(name, args);
                    break;
                }
                v = this.identifier(name);
                break;
            }
            case LPAREN: {
                this.consumeToken();
                v = this.expr(true);
                this.consumeToken(Scanner.Symbol.RPAREN);
                v = new AstNested(this.position, v);
            }
        }
        return v;
    }

    protected List<AstNode> list() throws Scanner.ScanException, ParseException {
        List<AstNode> l = Collections.emptyList();
        AstNode v = this.expr(false);
        if (v != null) {
            l = new ArrayList<AstNode>();
            l.add(v);
            while (this.token.getSymbol() == Scanner.Symbol.COMMA) {
                this.consumeToken();
                l.add(this.expr(true));
            }
        }
        return l;
    }

    protected AstNode literal() throws Scanner.ScanException, ParseException {
        AstNode v = null;
        switch (this.token.getSymbol()) {
            case TRUE: {
                v = new AstBoolean(this.position, true);
                this.consumeToken();
                break;
            }
            case FALSE: {
                v = new AstBoolean(this.position, false);
                this.consumeToken();
                break;
            }
            case STRING: {
                v = new AstString(this.position, this.token.getImage());
                this.consumeToken();
                break;
            }
            case INTEGER: {
                v = new AstNumber(this.position, this.parseInteger(this.token.getImage()));
                this.consumeToken();
                break;
            }
            case FLOAT: {
                v = new AstNumber(this.position, this.parseFloat(this.token.getImage()));
                this.consumeToken();
                break;
            }
            case NULL: {
                v = new AstNull(this.position);
                this.consumeToken();
                break;
            }
            case EXTENSION: {
                if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.LITERAL) break;
                v = this.getExtensionHandler(this.consumeToken()).createAstNode(new AstNode[0]);
            }
        }
        return v;
    }

    protected final AstFunction function(String name, List<AstNode> args) {
        AstFunction function = this.createAstFunction(name, args);
        return function;
    }

    protected final AstIdentifier identifier(String name) {
        AstIdentifier identifier = this.createAstIdentifier(name);
        return identifier;
    }

    public static abstract class ExtensionHandler {
        private final ExtensionPoint point;

        public ExtensionHandler(ExtensionPoint point) {
            this.point = point;
        }

        public ExtensionPoint getExtensionPoint() {
            return this.point;
        }

        public abstract AstNode createAstNode(AstNode ... var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExtensionPoint {
        OR,
        AND,
        EQ,
        CMP,
        ADD,
        MUL,
        UNARY,
        LITERAL;

    }

    private static final class LookaheadToken {
        final Scanner.Token token;
        final int position;

        LookaheadToken(Scanner.Token token, int position) {
            this.token = token;
            this.position = position;
        }
    }

    public static class ParseException
    extends Exception {
        final int position;
        final String encountered;
        final String expected;

        public ParseException(int position, String encountered, String expected) {
            super(LocalMessages.get("error.parse", position, encountered, expected));
            this.position = position;
            this.encountered = encountered;
            this.expected = expected;
        }

        public int getPosition() {
            return this.position;
        }

        public String getEncountered() {
            return this.encountered;
        }

        public String getExpected() {
            return this.expected;
        }
    }
}

